/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.texture.client.api;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.file.transfer.FileTransferPacket;
import net.frozenblock.lib.texture.client.api.ServerTexture;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ServerTextureDownloader {
    public static final Map<String, class_2960> WAITING_TEXTURES = new HashMap<String, class_2960>();
    private static final List<class_2960> LOADED_TEXTURES = new ArrayList<class_2960>();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String LOCAL_TEXTURE_SOURCE = ".local";

    public static class_2960 getOrLoadServerTexture(class_2960 texture, String destPath, String string, class_2960 fallback) {
        ServerTextureDownloader.downloadAndRegisterServerTexture(texture, destPath, string);
        if (LOADED_TEXTURES.contains(texture)) {
            return texture;
        }
        return fallback;
    }

    public static void downloadAndRegisterServerTexture(class_2960 texture, String destPath, String fileName) {
        if (LOADED_TEXTURES.contains(texture)) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            class_1011 image;
            try {
                image = ServerTextureDownloader.downloadServerTexture(texture, destPath, fileName);
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
            return image;
        }, class_156.method_55473().method_64116("downloadServerTexture")).thenCompose(image -> ServerTextureDownloader.registerTimedTextureInManager(texture, image, destPath, fileName));
    }

    @Nullable
    public static class_1011 downloadServerTexture(@Nullable class_2960 texture, String destPath, String fileName) throws IOException {
        Path path = class_310.method_1551().field_1697.toPath().resolve(destPath);
        Path possibleLocalPath = path.resolve(LOCAL_TEXTURE_SOURCE).resolve(fileName);
        if (Files.isRegularFile(possibleLocalPath, new LinkOption[0])) {
            class_1011 image;
            LOGGER.debug("Loading server texture from local cache ({})", (Object)destPath);
            try (InputStream inputStream = Files.newInputStream(possibleLocalPath, new OpenOption[0]);){
                image = class_1011.method_4309((InputStream)inputStream);
            }
            if (texture != null) {
                LOADED_TEXTURES.add(texture);
            }
            WAITING_TEXTURES.remove(ServerTextureDownloader.makePathFromRootAndDest(destPath, fileName));
            return image;
        }
        if (FrozenLibConfig.FILE_TRANSFER_CLIENT && texture != null) {
            ClientPlayNetworking.send((class_8710)FileTransferPacket.createRequest(destPath, fileName));
            WAITING_TEXTURES.put(ServerTextureDownloader.makePathFromRootAndDest(destPath, fileName), texture);
            LOGGER.debug("Requesting server texture from {}", (Object)path);
        }
        return null;
    }

    @Contract(pure=true)
    public static String makePathFromRootAndDest(String path, String dest) {
        return path + "/" + dest;
    }

    private static CompletableFuture<class_2960> registerTimedTextureInManager(class_2960 texture, class_1011 image, String destPath, String fileName) {
        class_310 minecraft = class_310.method_1551();
        return CompletableFuture.supplyAsync(() -> {
            minecraft.method_1531().method_4616(texture, (class_1044)new ServerTexture(image, destPath, fileName));
            return texture;
        }, (Executor)minecraft);
    }
}

