/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.biome.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_12199;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6544;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class FrozenBiome {
    private static final List<FrozenBiome> BIOMES = new ArrayList<FrozenBiome>();
    private final class_5321<class_1959> key = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)this.modID(), (String)this.biomeID()));
    private boolean enabled = true;

    protected FrozenBiome() {
        BIOMES.add(this);
    }

    public abstract String modID();

    public abstract String biomeID();

    public abstract float temperature();

    public abstract float downfall();

    public abstract boolean hasPrecipitation();

    public class_1959.class_5484 temperatureModifier() {
        return class_1959.class_5484.field_26407;
    }

    public abstract int waterColor();

    @Nullable
    public abstract Integer foliageColorOverride();

    @Nullable
    public abstract Integer dryFoliageColorOverride();

    @Nullable
    public abstract Integer grassColorOverride();

    public class_4763.class_5486 grassColorModifier() {
        return class_4763.class_5486.field_26426;
    }

    public abstract void fillEnvironmentAttributes(class_12199.class_12200 var1);

    public final class_1959 create(class_7891<class_1959> entries) {
        class_1959.class_1960 biomeBuilder = new class_1959.class_1960();
        biomeBuilder.method_8747(this.temperature()).method_30777(this.temperatureModifier()).method_8727(this.downfall()).method_48164(this.hasPrecipitation());
        class_7871 placedFeatures = entries.method_46799(class_7924.field_41245);
        class_7871 worldCarvers = entries.method_46799(class_7924.field_41238);
        class_5485.class_5495 featureBuilder = new class_5485.class_5495(placedFeatures, worldCarvers);
        this.addFeatures(featureBuilder);
        biomeBuilder.method_30973(featureBuilder.method_46671());
        class_5483.class_5496 spawnBuilder = new class_5483.class_5496();
        this.addSpawns(spawnBuilder);
        biomeBuilder.method_30974(spawnBuilder.method_31007());
        class_4763.class_4764 specialEffectsBuilder = new class_4763.class_4764().method_24395(this.waterColor()).method_30818(this.grassColorModifier());
        if (this.foliageColorOverride() != null) {
            specialEffectsBuilder.method_30821(this.foliageColorOverride().intValue());
        }
        if (this.dryFoliageColorOverride() != null) {
            specialEffectsBuilder.method_68149(this.dryFoliageColorOverride().intValue());
        }
        if (this.grassColorOverride() != null) {
            specialEffectsBuilder.method_30822(this.grassColorOverride().intValue());
        }
        biomeBuilder.method_24379(specialEffectsBuilder.method_24391());
        class_12199.class_12200 attributes = class_12199.method_75661();
        this.fillEnvironmentAttributes(attributes);
        return biomeBuilder.method_75738(attributes).method_30972();
    }

    public abstract void addFeatures(class_5485.class_5495 var1);

    public abstract void addSpawns(class_5483.class_5496 var1);

    public abstract void injectToOverworld(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> var1);

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public class_5321<class_1959> getKey() {
        return this.key;
    }

    public final void addSurfaceBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> consumer, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset) {
        consumer.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)weirdness, (float)offset), this.getKey()));
        consumer.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)weirdness, (float)offset), this.getKey()));
    }

    public final void addSemiDeepBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset) {
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.4f, (float)1.0f), (class_6544.class_6546)weirdness, (float)offset), this.getKey()));
    }

    public final void addUndergroundBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> consumer, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset) {
        consumer.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.2f, (float)0.9f), (class_6544.class_6546)weirdness, (float)offset), this.getKey()));
    }

    public final void addBottomBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> consumer, class_6544.class_6546 temerature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset) {
        consumer.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temerature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.1f), (class_6544.class_6546)weirdness, (float)offset), this.getKey()));
    }

    public static ImmutableList<FrozenBiome> getFrozenBiomes() {
        return ImmutableList.copyOf(BIOMES);
    }
}

