/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.block_predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.lib.worldgen.feature.api.block_predicate.FrozenLibBlockPredicateTypes;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_5281;
import net.minecraft.class_6646;
import net.minecraft.class_6647;
import org.jetbrains.annotations.Contract;

public class SearchInDirectionBlockPredicate
implements class_6646 {
    public static final MapCodec<SearchInDirectionBlockPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6646.field_35054.fieldOf("block_predicate").forGetter(config -> config.blockPredicate), (App)Codec.INT.fieldOf("search_steps").forGetter(config -> config.searchSteps), (App)class_2350.field_29502.fieldOf("search_direction").forGetter(config -> config.searchDirection), (App)Codec.BOOL.fieldOf("all_must_match").forGetter(config -> config.allMustMatch)).apply((Applicative)instance, SearchInDirectionBlockPredicate::new));
    private final class_6646 blockPredicate;
    private final int searchSteps;
    private final class_2350 searchDirection;
    private final boolean allMustMatch;

    public SearchInDirectionBlockPredicate(class_6646 blockPredicate, int searchSteps, class_2350 searchDirection, boolean allMustMatch) {
        this.blockPredicate = blockPredicate;
        this.searchSteps = searchSteps;
        this.searchDirection = searchDirection;
        this.allMustMatch = allMustMatch;
    }

    public static SearchInDirectionBlockPredicate anyAboveMatch(class_6646 blockPredicate, int searchSteps) {
        return new SearchInDirectionBlockPredicate(blockPredicate, searchSteps, class_2350.field_11036, false);
    }

    public static SearchInDirectionBlockPredicate allAboveMatch(class_6646 blockPredicate, int searchSteps) {
        return new SearchInDirectionBlockPredicate(blockPredicate, searchSteps, class_2350.field_11036, true);
    }

    public static SearchInDirectionBlockPredicate anyBelowMatch(class_6646 blockPredicate, int searchSteps) {
        return new SearchInDirectionBlockPredicate(blockPredicate, searchSteps, class_2350.field_11036, false);
    }

    public static SearchInDirectionBlockPredicate allBelowMatch(class_6646 blockPredicate, int searchSteps) {
        return new SearchInDirectionBlockPredicate(blockPredicate, searchSteps, class_2350.field_11036, true);
    }

    @Contract(value="_ -> new")
    public static SearchInDirectionBlockPredicate hasWaterAbove(int searchSteps) {
        return SearchInDirectionBlockPredicate.anyAboveMatch(class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_10382}), searchSteps);
    }

    @Contract(value="_ -> new")
    public static SearchInDirectionBlockPredicate hasLavaAbove(int searchSteps) {
        return SearchInDirectionBlockPredicate.anyAboveMatch(class_6646.method_43290((class_2248[])new class_2248[]{class_2246.field_10164}), searchSteps);
    }

    public class_6647<?> method_38873() {
        return FrozenLibBlockPredicateTypes.SEARCH_IN_DIRECTION;
    }

    public boolean test(class_5281 level, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int step = 1; step <= this.searchSteps; ++step) {
            if (this.blockPredicate.test((Object)level, (Object)mutable.method_10104(this.searchDirection, step))) {
                if (this.allMustMatch) continue;
                return true;
            }
            if (!this.allMustMatch) continue;
            return false;
        }
        return this.allMustMatch;
    }
}

