/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.frozenblock.lib.worldgen.feature.api.feature.config.LargeSpireConfig;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;
import org.jetbrains.annotations.Nullable;

public class LargeSpireFeature
extends class_3031<LargeSpireConfig> {
    public LargeSpireFeature(Codec<LargeSpireConfig> codec) {
        super(codec);
    }

    private static LargeSpire make(class_2338 root, boolean pointingUp, class_5819 random, int radius, class_5863 bluntnessBase, class_5863 scaleBase) {
        return new LargeSpire(root, pointingUp, radius, bluntnessBase.method_33920(random), scaleBase.method_33920(random));
    }

    protected static boolean isCircleMostlyEmbeddedInStone(class_5281 level, class_2338 pos, int radius) {
        if (LargeSpireFeature.isEmptyOrWaterOrLava((class_1936)level, pos)) {
            return false;
        }
        float increment = 6.0f / (float)radius;
        for (float f = 0.0f; f < (float)Math.PI * 2; f += increment) {
            int zOffset;
            int xOffset = (int)(class_3532.method_15362((double)f) * (float)radius);
            if (!LargeSpireFeature.isEmptyOrWaterOrLava((class_1936)level, pos.method_10069(xOffset, 0, zOffset = (int)(class_3532.method_15374((double)f) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWaterOrLava(class_1936 level, class_2338 pos) {
        return level.method_16358(pos, LargeSpireFeature::isEmptyOrWaterOrLava);
    }

    public static boolean isEmptyOrWaterOrLava(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10164);
    }

    protected static double getHeight(double radius, double maxRadius, double scale, double minRadius) {
        if (radius < minRadius) {
            radius = minRadius;
        }
        double e = radius / maxRadius * 0.384;
        double f = 0.75 * Math.pow(e, 1.3333333333333333);
        double g = Math.pow(e, 0.6666666666666666);
        double h = 0.3333333333333333 * Math.log(e);
        double i = Math.max(scale * (f - g - h), 0.0);
        return i / 0.384 * maxRadius;
    }

    public boolean method_13151(class_5821<LargeSpireConfig> context) {
        WindOffsetter windOffsetter;
        Object t;
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        LargeSpireConfig config = (LargeSpireConfig)context.method_33656();
        class_5819 random = context.method_33654();
        if (!LargeSpireFeature.isEmptyOrWaterOrLava((class_1936)level, pos)) {
            return false;
        }
        Optional optionalColumn = class_5721.method_32982((class_3746)level, (class_2338)pos, (int)config.floorToCeilingSearchRange(), class_5726::method_33389, state -> LargeSpireFeature.isBaseOrLava(config, state));
        if (optionalColumn.isEmpty() || !((t = optionalColumn.get()) instanceof class_5721.class_5723)) {
            return false;
        }
        class_5721.class_5723 range = (class_5721.class_5723)t;
        if (range.method_32992() < 4) {
            return false;
        }
        int radiusByHeight = (int)((float)range.method_32992() * config.maxColumnRadiusToCaveHeightRatio());
        int clampedRadius = class_3532.method_15340((int)radiusByHeight, (int)config.columnRadius().method_35009(), (int)config.columnRadius().method_35011());
        int radius = class_3532.method_32751((class_5819)random, (int)config.columnRadius().method_35009(), (int)clampedRadius);
        LargeSpire ceilingSpire = LargeSpireFeature.make(pos.method_33096(range.method_32990() - 1), false, random, radius, config.stalactiteBluntness(), config.heightScale());
        LargeSpire floorSpire = LargeSpireFeature.make(pos.method_33096(range.method_32991() + 1), true, random, radius, config.stalagmiteBluntness(), config.heightScale());
        WindOffsetter windOffsetter2 = windOffsetter = ceilingSpire.isSuitableForWind(config) && floorSpire.isSuitableForWind(config) ? new WindOffsetter(pos.method_10264(), random, config.windSpeed()) : WindOffsetter.noWind();
        if (ceilingSpire.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter)) {
            ceilingSpire.placeBlocks(level, random, windOffsetter, config);
        }
        if (floorSpire.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(level, windOffsetter)) {
            floorSpire.placeBlocks(level, random, windOffsetter, config);
        }
        return true;
    }

    public static boolean isBaseOrLava(LargeSpireConfig config, class_2680 state) {
        return LargeSpireFeature.isBase(config, state) || state.method_27852(class_2246.field_10164);
    }

    public static boolean isBase(LargeSpireConfig config, class_2680 state) {
        return state.method_40143(config.baseBlocks()) || state.method_40143(config.replaceable());
    }

    static final class LargeSpire {
        private final boolean pointingUp;
        private final double bluntness;
        private final double scale;
        private class_2338 root;
        private int radius;

        LargeSpire(class_2338 root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = root;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(class_5281 level, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                class_2338.class_2339 mutable = this.root.method_25503();
                int searchRange = Math.min(10, this.getHeight());
                for (int j = 0; j < searchRange; ++j) {
                    if (LargeSpireFeature.isCircleMostlyEmbeddedInStone(level, windOffsetter.offset((class_2338)mutable), this.radius)) {
                        this.root = mutable;
                        return true;
                    }
                    mutable.method_10098(this.pointingUp ? class_2350.field_11033 : class_2350.field_11036);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radius) {
            return (int)LargeSpireFeature.getHeight(radius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(class_5281 level, class_5819 random, WindOffsetter windOffsetter, LargeSpireConfig config) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                block1: for (int z = -this.radius; z <= this.radius; ++z) {
                    int heightAtRadius;
                    float distance = class_3532.method_15355((float)(x * x + z * z));
                    if (distance > (float)this.radius || (heightAtRadius = this.getHeightAtRadius(distance)) <= 0) continue;
                    if (random.method_43057() < 0.2f) {
                        heightAtRadius = (int)((float)heightAtRadius * class_3532.method_32750((class_5819)random, (float)0.8f, (float)1.0f));
                    }
                    class_2338.class_2339 mutable = this.root.method_10069(x, 0, z).method_25503();
                    boolean bl = false;
                    int searchAttempts = this.pointingUp ? level.method_8624(class_2902.class_2903.field_13194, mutable.method_10263(), mutable.method_10260()) : Integer.MAX_VALUE;
                    for (int i = 0; i < heightAtRadius && mutable.method_10264() < searchAttempts; ++i) {
                        class_2338 pos = windOffsetter.offset((class_2338)mutable);
                        if (LargeSpireFeature.isEmptyOrWaterOrLava((class_1936)level, pos)) {
                            bl = true;
                            level.method_8652(pos, config.pathBlock().method_23455(random, (class_2338)mutable), 3);
                        } else if (bl && level.method_8320(pos).method_26164(class_3481.field_25807)) continue block1;
                        mutable.method_10098(this.pointingUp ? class_2350.field_11036 : class_2350.field_11033);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargeSpireConfig config) {
            return this.radius >= config.minRadiusForWind() && this.bluntness >= (double)config.minBluntnessForWind();
        }
    }

    private static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final class_243 windSpeed;

        WindOffsetter(int originY, class_5819 random, class_5863 magnitude) {
            this.originY = originY;
            float magnitudeSample = magnitude.method_33920(random);
            float circleSample = class_3532.method_32750((class_5819)random, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new class_243((double)(class_3532.method_15362((double)circleSample) * magnitudeSample), 0.0, (double)(class_3532.method_15374((double)circleSample) * magnitudeSample));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        class_2338 offset(class_2338 pos) {
            if (this.windSpeed == null) {
                return pos;
            }
            class_243 vec3 = this.windSpeed.method_1021((double)(this.originY - pos.method_10264()));
            return pos.method_10081((class_2382)class_2338.method_49637((double)vec3.field_1352, (double)0.0, (double)vec3.field_1350));
        }
    }
}

