/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.core.registry.api.sync;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.frozenblock.lib.entrypoint.api.CommonEventEntrypoint;
import net.frozenblock.lib.event.api.FrozenEvents;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocolDef;
import org.slf4j.Logger;

public class ModProtocol {
    public static final Event<LoadModProtocol> LOAD_MOD_PROTOCOL = FrozenEvents.createEnvironmentEvent(LoadModProtocol.class, callbacks -> () -> {
        for (LoadModProtocol callback : callbacks) {
            callback.load();
        }
    });
    public static final List<ModProtocolDef> REQUIRED = new ArrayList<ModProtocolDef>();
    public static final List<ModProtocolDef> ALL = new ArrayList<ModProtocolDef>();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, ModProtocolDef> PROTOCOL_VERSIONS = new HashMap<String, ModProtocolDef>();
    public static boolean enabled = false;
    public static boolean disableQuery = false;
    public static String prioritizedId = "";
    public static ModProtocolDef prioritizedEntry;

    public static void loadVersions() {
        ((LoadModProtocol)LOAD_MOD_PROTOCOL.invoker()).load();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata data = container.getMetadata();
            CustomValue frozenRegistry = data.getCustomValue("frozenlib_registry");
            if (frozenRegistry == null) continue;
            if (frozenRegistry.getType() != CustomValue.CvType.OBJECT) {
                LOGGER.warn("Mod {} ({}) contains invalid 'frozenlib_registry' entry! Expected 'OBJECT', found '{}'", new Object[]{container.getMetadata().getName(), container.getMetadata().getId(), frozenRegistry.getType()});
                continue;
            }
            CustomValue value = frozenRegistry.getAsObject().get("mod_protocol");
            if (value == null || value.getType() == CustomValue.CvType.NULL) continue;
            if (value.getType() == CustomValue.CvType.OBJECT) {
                IntList version;
                CustomValue.CvObject object = value.getAsObject();
                boolean optional = false;
                CustomValue optVal = object.get("optional");
                if (optVal != null) {
                    if (optVal.getType() != CustomValue.CvType.BOOLEAN) {
                        ModProtocol.invalidEntryType(".optional", container, CustomValue.CvType.BOOLEAN, optVal.getType());
                        continue;
                    }
                    optional = optVal.getAsBoolean();
                }
                if ((version = ModProtocol.decodeVersion(".value", container, object.get("value"))) == null) continue;
                ModProtocol.add(new ModProtocolDef("mod:" + data.getId(), data.getName(), version, optional));
                continue;
            }
            IntList version = ModProtocol.decodeVersion("", container, value);
            if (version == null) continue;
            ModProtocol.add(new ModProtocolDef("mod:" + data.getId(), data.getName(), version, false));
        }
    }

    private static IntList decodeVersion(String path, ModContainer container, CustomValue value) {
        if (value == null) {
            ModProtocol.invalidEntryType(path, container, CustomValue.CvType.NUMBER, CustomValue.CvType.NULL);
            return null;
        }
        if (value.getType() == CustomValue.CvType.NUMBER) {
            int version = value.getAsNumber().intValue();
            if (version < 0) {
                ModProtocol.negativeEntry(path, container, version);
                return null;
            }
            return IntList.of((int)version);
        }
        if (value.getType() == CustomValue.CvType.ARRAY) {
            CustomValue.CvArray array = value.getAsArray();
            IntArrayList versions = new IntArrayList(array.size());
            for (int i = 0; i < array.size(); ++i) {
                int version;
                CustomValue entry = array.get(i);
                if (entry.getType() == CustomValue.CvType.NUMBER) {
                    version = entry.getAsNumber().intValue();
                    if (version < 0) {
                        ModProtocol.negativeEntry(path + "[" + i + "]", container, version);
                        return null;
                    }
                } else {
                    ModProtocol.invalidEntryType(path + "[" + i + "]", container, CustomValue.CvType.NUMBER, entry.getType());
                    return null;
                }
                versions.add(version);
            }
            return versions;
        }
        ModProtocol.invalidEntryType(path + ".optional", container, CustomValue.CvType.NUMBER, value.getType());
        return null;
    }

    private static void invalidEntryType(String path, ModContainer c, CustomValue.CvType expected, CustomValue.CvType found) {
        LOGGER.warn("Mod {} ({}) contains invalid 'frozenlib_registry.mod_protocol{}' entry! Expected '{}', found '{}'", new Object[]{path, c.getMetadata().getName(), c.getMetadata().getId(), expected.name(), found.name()});
    }

    private static void negativeEntry(String path, ModContainer c, int i) {
        LOGGER.warn("Mod {} ({}) contains invalid 'frozenlib_registry.mod_protocol{}' entry! Protocol requires non-negative integer, found '{}'!", new Object[]{path, c.getMetadata().getName(), c.getMetadata().getId(), i});
    }

    public static IntList getVersion(String string) {
        ModProtocolDef x = PROTOCOL_VERSIONS.get(string);
        return x == null ? IntList.of() : x.versions();
    }

    public static void add(ModProtocolDef def) {
        PROTOCOL_VERSIONS.put(def.id(), def);
        if (!def.optional()) {
            REQUIRED.add(def);
        }
        ALL.add(def);
        enabled = true;
    }

    @FunctionalInterface
    public static interface LoadModProtocol
    extends CommonEventEntrypoint {
        public void load();
    }
}

