/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.core.registry.impl.sync.server;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_11341;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocol;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ClientPackets;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ProtocolVersions;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ServerPackets;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.server.QuiltSyncTask;

@ApiStatus.Internal
public final class ServerRegistrySync {
    private static final int MAX_SAFE_PACKET_SIZE = 734003;
    public static class_2561 noRegistrySyncMessage = class_2561.method_43473();
    public static class_2561 errorStyleHeader = class_2561.method_43473();
    public static class_2561 errorStyleFooter = class_2561.method_43473();
    public static boolean forceDisable = false;
    public static boolean showErrorDetails = true;
    public static IntList SERVER_SUPPORTED_PROTOCOL = new IntArrayList((IntCollection)ProtocolVersions.IMPL_SUPPORTED_VERSIONS);

    public static void registerHandlers() {
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ServerPackets.Handshake.PACKET_TYPE) && ServerConfigurationNetworking.canSend((class_8610)handler, ServerPackets.ErrorStyle.PACKET_TYPE) && ServerConfigurationNetworking.canSend((class_8610)handler, ServerPackets.ModProtocol.PACKET_TYPE) && ServerConfigurationNetworking.canSend((class_8610)handler, ServerPackets.End.PACKET_TYPE)) {
                handler.addTask((class_8605)new QuiltSyncTask(handler, handler.field_45013));
            }
        });
        PayloadTypeRegistry registryClient = PayloadTypeRegistry.configurationC2S();
        registryClient.register(ClientPackets.Handshake.PACKET_TYPE, ClientPackets.Handshake.CODEC);
        registryClient.register(ClientPackets.ModProtocol.PACKET_TYPE, ClientPackets.ModProtocol.CODEC);
        registryClient.register(ClientPackets.End.PACKET_TYPE, ClientPackets.End.CODEC);
        ServerConfigurationNetworking.registerGlobalReceiver(ClientPackets.Handshake.PACKET_TYPE, ServerRegistrySync::handleHandshake);
        ServerConfigurationNetworking.registerGlobalReceiver(ClientPackets.ModProtocol.PACKET_TYPE, ServerRegistrySync::handleModProtocol);
        ServerConfigurationNetworking.registerGlobalReceiver(ClientPackets.End.PACKET_TYPE, ServerRegistrySync::handleEnd);
        PayloadTypeRegistry registry = PayloadTypeRegistry.configurationS2C();
        registry.register(ServerPackets.Handshake.PACKET_TYPE, ServerPackets.Handshake.CODEC);
        registry.register(ServerPackets.ModProtocol.PACKET_TYPE, ServerPackets.ModProtocol.CODEC);
        registry.register(ServerPackets.End.PACKET_TYPE, ServerPackets.End.CODEC);
        registry.register(ServerPackets.ErrorStyle.PACKET_TYPE, ServerPackets.ErrorStyle.CODEC);
    }

    public static void handleHandshake(ClientPackets.Handshake handshake, ServerConfigurationNetworking.Context context) {
        ((QuiltSyncTask)context.networkHandler().field_45024).handleHandshake(handshake);
    }

    public static void handleModProtocol(ClientPackets.ModProtocol modProtocol, ServerConfigurationNetworking.Context context) {
        ((QuiltSyncTask)context.networkHandler().field_45024).handleModProtocol(modProtocol, context.responseSender());
    }

    public static void handleEnd(ClientPackets.End end, ServerConfigurationNetworking.Context context) {
        ((QuiltSyncTask)context.networkHandler().field_45024).handleEnd(end);
    }

    public static class_2561 text(String string) {
        if (string == null || string.isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 text = null;
        try {
            JsonElement json = class_11341.method_71360((String)string);
            text = (class_2561)class_8824.field_46597.parse((DynamicOps)class_5455.field_40585.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)json).resultOrPartial().orElseThrow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text != null ? text : class_2561.method_43470((String)string);
    }

    public static boolean isNamespaceVanilla(String namespace) {
        return namespace.equals("minecraft") || namespace.equals("brigadier");
    }

    public static boolean shouldSync() {
        if (forceDisable) {
            return false;
        }
        return ModProtocol.enabled;
    }

    public static boolean requiresSync() {
        if (forceDisable) {
            return false;
        }
        return !ModProtocol.REQUIRED.isEmpty();
    }

    public static void sendSyncPackets(PacketSender sender, int syncVersion) {
        ServerRegistrySync.sendErrorStylePacket(sender);
        if (ModProtocol.enabled) {
            ServerRegistrySync.sendModProtocol(sender);
        }
        sender.sendPacket((class_8710)new ServerPackets.End());
    }

    public static void sendHelloPacket(PacketSender sender) {
        sender.sendPacket((class_8710)new ServerPackets.Handshake(SERVER_SUPPORTED_PROTOCOL));
    }

    public static void sendModProtocol(PacketSender sender) {
        sender.sendPacket((class_8710)new ServerPackets.ModProtocol(ModProtocol.prioritizedId, ModProtocol.ALL));
    }

    private static void sendErrorStylePacket(PacketSender sender) {
        sender.sendPacket((class_8710)new ServerPackets.ErrorStyle(errorStyleHeader, errorStyleFooter, showErrorDetails));
    }
}

