/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.class_11372;
import net.minecraft.class_155;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.NoOpQuiltDataFixesInternals;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.QuiltDataFixesInternalsImpl;
import org.slf4j.Logger;

@ApiStatus.Internal
public abstract class QuiltDataFixesInternals {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static QuiltDataFixesInternals instance;

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) Optional<Integer> getModDataVersion(class_2487 tag, String modId) {
        String key = modId + "_DataVersion";
        return tag.method_10545(key) ? tag.method_10550(modId + "_DataVersion") : Optional.empty();
    }

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) Optional<Integer> getModMinecraftDataVersion(class_2487 tag, String modId) {
        String key = modId + "_DataVersion_Minecraft";
        return tag.method_10545(key) ? tag.method_10550(modId + "_DataVersion_Minecraft") : Optional.empty();
    }

    public static QuiltDataFixesInternals get() {
        Schema latestVanillaSchema;
        if (instance != null) {
            return instance;
        }
        try {
            latestVanillaSchema = class_3551.method_15450().getSchema(DataFixUtils.makeKey((int)class_155.method_16673().comp_4026().comp_4038()));
        }
        catch (Exception e) {
            latestVanillaSchema = null;
        }
        if (latestVanillaSchema == null) {
            LOGGER.warn("[Quilt DFU API] Failed to initialize! Either someone stopped DFU from initializing,");
            LOGGER.warn("[Quilt DFU API]  or this Minecraft build is hosed.");
            LOGGER.warn("[Quilt DFU API] Using no-op implementation.");
            instance = new NoOpQuiltDataFixesInternals();
        } else {
            instance = new QuiltDataFixesInternalsImpl(latestVanillaSchema);
        }
        return instance;
    }

    public abstract void registerFixer(String var1, @Range(from=0L, to=0x7FFFFFFFL) int var2, DataFixer var3);

    public abstract boolean isEmpty();

    @Nullable
    public abstract DataFixerEntry getFixerEntry(String var1);

    public abstract void registerMinecraftFixer(String var1, @Range(from=0L, to=0x7FFFFFFFL) int var2, DataFixer var3);

    @Nullable
    public abstract DataFixerEntry getMinecraftFixerEntry(String var1);

    @Contract(value="-> new", pure=true)
    public abstract Schema createBaseSchema();

    public abstract Dynamic<class_2520> updateWithAllFixers(class_4284 var1, Dynamic<class_2520> var2);

    public abstract class_2487 addModDataVersions(class_2487 var1);

    public abstract void addModDataVersions(class_11372 var1);

    public abstract void freeze();

    @Contract(pure=true)
    public abstract boolean isFrozen();

    public record DataFixerEntry(DataFixer dataFixer, int currentVersion) {
    }
}

