/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.MaterialType;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static ResourceLocation mcLoc(@NotNull String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    @NotNull
    public static ResourceLocation mcBlockLoc(@NotNull String path) {
        return Utils.mcLoc("block/" + path);
    }

    @NotNull
    public static ResourceLocation mcItemLoc(@NotNull String path) {
        return Utils.mcLoc("item/" + path);
    }

    @NotNull
    public static ResourceLocation modLoc(@NotNull String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"ytech", (String)path);
    }

    @NotNull
    public static ResourceLocation modLoc(@NotNull Item item) {
        return Utils.modLoc(Utils.loc(item).getPath());
    }

    @NotNull
    public static ResourceLocation modLoc(@NotNull DeferredHolder<?, ?> object) {
        return Utils.modLoc(object.getId().getPath());
    }

    @NotNull
    public static ResourceLocation modBlockLoc(@NotNull String path) {
        return Utils.modLoc("block/" + path);
    }

    @NotNull
    public static ResourceLocation modItemLoc(@NotNull String path) {
        return Utils.modLoc("item/" + path);
    }

    @NotNull
    public static ResourceLocation loc(@NotNull Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    @NotNull
    public static ResourceLocation loc(@NotNull Item item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    @NotNull
    public static ResourceLocation loc(@NotNull DeferredItem<? extends Item> item) {
        return Utils.loc((Item)item.get());
    }

    @NotNull
    public static ResourceLocation loc(@NotNull DeferredBlock<Block> block) {
        return Utils.loc((Block)block.get());
    }

    @NotNull
    public static ResourceLocation blockLoc(@NotNull Block block) {
        ResourceLocation loc = Utils.loc(block);
        return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath()));
    }

    public static String getPath(DeferredHolder<?, ?> object) {
        return object.getId().getPath();
    }

    @NotNull
    public static String getHasItem(TagKey<Item> item) {
        return "has_" + item.location().getPath();
    }

    public static String getHasItem(DeferredHolder<?, ?> item) {
        return "has_" + Utils.getPath(item);
    }

    @NotNull
    public static String getHasName() {
        return "has_item";
    }

    @NotNull
    public static TagKey<Item> getLogFromMaterial(MaterialType material) {
        return switch (material) {
            case MaterialType.ACACIA_WOOD -> ItemTags.ACACIA_LOGS;
            case MaterialType.BIRCH_WOOD -> ItemTags.BIRCH_LOGS;
            case MaterialType.CHERRY_WOOD -> ItemTags.CHERRY_LOGS;
            case MaterialType.DARK_OAK_WOOD -> ItemTags.DARK_OAK_LOGS;
            case MaterialType.JUNGLE_WOOD -> ItemTags.JUNGLE_LOGS;
            case MaterialType.MANGROVE_WOOD -> ItemTags.MANGROVE_LOGS;
            case MaterialType.OAK_WOOD -> ItemTags.OAK_LOGS;
            case MaterialType.SPRUCE_WOOD -> ItemTags.SPRUCE_LOGS;
            default -> throw new IllegalStateException("Not wood type provided!");
        };
    }

    @NotNull
    public static CompoundTag saveBlockPos(@NotNull BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        return tag;
    }

    @NotNull
    public static BlockPos loadBlockPos(@NotNull CompoundTag tag) {
        return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
    }

    @SafeVarargs
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> merge(@NotNull EnumSet<E> first, E ... list) {
        Object copy = first.clone();
        ((AbstractCollection)copy).addAll(Arrays.asList(list));
        return copy;
    }

    @SafeVarargs
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> exclude(@NotNull EnumSet<E> enumSet, E ... list) {
        Object copy = enumSet.clone();
        for (E e : list) {
            ((AbstractCollection)copy).remove(e);
        }
        return copy;
    }

    @NotNull
    public static <E extends Enum<E>> EnumSet<E> exclude(@NotNull EnumSet<E> enumSet, @NotNull EnumSet<E> toRemove) {
        Object copy = enumSet.clone();
        ((AbstractSet)copy).removeAll(toRemove);
        return copy;
    }
}

