/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorMaterials;
import net.minecraft.world.item.equipment.ArmorType;

public enum YTechArmorMaterials {
    IRON(MaterialType.IRON, ArmorMaterials.IRON),
    GOLD(MaterialType.GOLD, ArmorMaterials.GOLD),
    COPPER(MaterialType.COPPER, 7, 20, 0, 0, 1, 2, 3, 3, 3),
    BRONZE(MaterialType.BRONZE, 10, 25, 0, 0, 1, 2, 4, 3, 3);

    private static final Map<MaterialType, ArmorMaterial> ARMORS;
    public final MaterialType materialType;
    public final ArmorMaterial armorMaterial;

    private YTechArmorMaterials(MaterialType materialType, ArmorMaterial armorMaterial) {
        this.materialType = materialType;
        this.armorMaterial = armorMaterial;
    }

    private YTechArmorMaterials(MaterialType materialType, int durability, int enc, int toughness, int knockbackResistance, int armBody, int armBoots, int armChestplate, int armHelmet, int armLeggings) {
        this.materialType = materialType;
        this.armorMaterial = new ArmorMaterial(durability, Map.of(ArmorType.BODY, armBody, ArmorType.BOOTS, armBoots, ArmorType.CHESTPLATE, armChestplate, ArmorType.HELMET, armHelmet, ArmorType.LEGGINGS, armLeggings), enc, SoundEvents.ARMOR_EQUIP_IRON, (float)toughness, (float)knockbackResistance, (TagKey)YTechItemTags.INGOTS.get(materialType), Utils.modLoc(materialType.key));
    }

    public static ArmorMaterial get(MaterialType materialType) {
        return ARMORS.get(materialType);
    }

    static {
        ARMORS = new HashMap<MaterialType, ArmorMaterial>();
        for (YTechArmorMaterials value : YTechArmorMaterials.values()) {
            ARMORS.put(value.materialType, value.armorMaterial);
        }
    }
}

