/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.AmphoraBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;

public class AmphoraBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);

    public AmphoraBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public boolean propagatesSkylightDown(@NotNull BlockState pState) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new AmphoraBlockEntity(blockPos, blockState);
    }

    @NotNull
    public InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.AMPHORA.get());
        if (optional.isPresent()) {
            return ((AmphoraBlockEntity)((Object)optional.get())).useItemOn(stack, level, pos, player, hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AmphoraBlockEntity) {
            AmphoraBlockEntity amphoraBlockEntity = (AmphoraBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)NonNullList.withSize((int)1, (Object)amphoraBlockEntity.getItem()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.AMPHORA))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(5.0f, 13.0f, 11.0f, 16.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#0").cullface(direction);
                }
            }
        }).from(5.0f, 0.0f, 5.0f).to(11.0f, 3.0f, 11.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(3.0f, 4.0f, 13.0f, 14.0f).texture("#1");
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#0");
                }
            }
        }).from(3.0f, 6.0f, 3.0f).to(13.0f, 16.0f, 13.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#1");
                }
            }
        }).from(5.999f, 16.0f, 5.999f).to(10.001f, 18.0f, 10.001f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(4.0f, 10.0f, 12.0f, 13.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(4.0f, 4.0f, 12.0f, 12.0f).texture("#2");
                }
            }
        }).from(4.0f, 3.0f, 4.0f).to(12.0f, 6.0f, 12.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(5.0f, 0.0f, 11.0f, 2.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#0");
                }
            }
        }).from(4.999f, 18.0f, 4.999f).to(11.001f, 19.999f, 11.001f).end()).texture("particle", Utils.modBlockLoc("amphora/amphora_side"))).texture("0", Utils.modBlockLoc("amphora/amphora_base"))).texture("1", Utils.modBlockLoc("amphora/amphora_side"))).texture("2", Utils.modBlockLoc("amphora/amphora_top"));
        provider.simpleBlock((Block)YTechBlocks.AMPHORA.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.AMPHORA))).parent((ModelFile)model);
    }
}

