/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.AqueductConsumerBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AqueductConsumerBlock
extends IrrigationBlock {
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");

    public AqueductConsumerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        Level level = blockPlaceContext.getLevel();
        BlockPos pos = blockPlaceContext.getClickedPos();
        boolean hasNorthConnection = AqueductConsumerBlock.isValidForConnection((LevelReader)level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductConsumerBlock.isValidForConnection((LevelReader)level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductConsumerBlock.isValidForConnection((LevelReader)level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductConsumerBlock.isValidForConnection((LevelReader)level, pos, Direction.WEST);
        state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(hasNorthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(hasEastConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(hasSouthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(hasWestConnection));
        return state;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        boolean hasNorthConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductConsumerBlock.isValidForConnection(level, pos, Direction.WEST);
        state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(hasNorthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(hasEastConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(hasSouthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(hasWestConnection));
        return state;
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, neighborBlock, orientation, movedByPiston);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AqueductConsumerBlockEntity) {
            AqueductConsumerBlockEntity blockEntity2 = (AqueductConsumerBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(blockEntity2);
            if (network != null) {
                blockEntity2.neighborChanged();
            }
        }
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return Direction.Plane.HORIZONTAL.stream().map(dir -> pos.offset(dir.getUnitVec3i())).toList();
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        AqueductConsumerBlockEntity hydratorBlock;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AqueductConsumerBlockEntity && (hydratorBlock = (AqueductConsumerBlockEntity)blockEntity).isHydrating() && random.nextInt(10) == 0) {
            level.playLocalSound(pos, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BlockStateProperties.EAST}).add(new Property[]{BlockStateProperties.WEST}).add(new Property[]{BlockStateProperties.SOUTH}).add(new Property[]{BlockStateProperties.NORTH}).add(new Property[]{ACTIVATED});
    }

    protected static void createAqueductConsumerTicker(@NotNull Level level, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof AqueductConsumerBlockEntity) {
            AqueductConsumerBlockEntity block = (AqueductConsumerBlockEntity)blockEntity;
            block.tick((ServerLevel)level);
        }
    }
}

