/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.jetbrains.annotations.NotNull;

public abstract class IrrigationBlock
extends BaseEntityBlock {
    public static final Map<Direction, Integer> ANGLE_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, 0);
        enumMap.put(Direction.EAST, 90);
        enumMap.put(Direction.SOUTH, 180);
        enumMap.put(Direction.WEST, 270);
    })));
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, BlockStateProperties.NORTH);
        enumMap.put(Direction.EAST, BlockStateProperties.EAST);
        enumMap.put(Direction.SOUTH, BlockStateProperties.SOUTH);
        enumMap.put(Direction.WEST, BlockStateProperties.WEST);
    })));

    public IrrigationBlock(@NotNull BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(@NotNull BlockState oldBlockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newBlockState, boolean movedByPiston) {
        if (!level.isClientSide) {
            BlockEntity blockEntity;
            if (!(!oldBlockState.hasBlockEntity() || oldBlockState.is(newBlockState.getBlock()) && newBlockState.hasBlockEntity())) {
                IIrrigationBlockEntity kineticBlockEntity;
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof IIrrigationBlockEntity && (kineticBlockEntity = (IIrrigationBlockEntity)blockEntity2).getNetworkId() >= 0) {
                    kineticBlockEntity.onRemove();
                }
            } else if (oldBlockState.hasBlockEntity() && oldBlockState.is(newBlockState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof IIrrigationBlockEntity) {
                IIrrigationBlockEntity kineticBlockEntity = (IIrrigationBlockEntity)blockEntity;
                kineticBlockEntity.onChangedState(oldBlockState, newBlockState);
            }
        }
        super.onRemove(oldBlockState, level, pos, newBlockState, movedByPiston);
    }

    abstract List<BlockPos> getValidNeighbors(@NotNull BlockState var1, @NotNull BlockPos var2);

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new RuntimeException("Not implemented yet!");
    }

    static boolean isValidForConnection(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockPos neighborPos = pos.offset(direction.getUnitVec3i());
        BlockState blockState = level.getBlockState(neighborPos);
        Block block = blockState.getBlock();
        if (block instanceof IrrigationBlock) {
            IrrigationBlock irrigationBlock = (IrrigationBlock)block;
            return irrigationBlock.getValidNeighbors(blockState, neighborPos).contains(pos);
        }
        return false;
    }
}

