/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.PottersWheelBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PottersWheelBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.1875, (double)0.875), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.4375, (double)0.1875, (double)0.4375, (double)0.5625, (double)0.6875, (double)0.5625), Shapes.box((double)0.25, (double)0.6875, (double)0.25, (double)0.75, (double)0.875, (double)0.75)});

    public PottersWheelBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.TERRACOTTA_BROWN));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new PottersWheelBlockEntity(blockPos, blockState);
    }

    @NotNull
    public InteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.POTTERS_WHEEL.get());
        if (optional.isPresent()) {
            return ((PottersWheelBlockEntity)((Object)optional.get())).onUse(state, level, pos, player, hand);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof PottersWheelBlockEntity) {
            PottersWheelBlockEntity pottersWheel = (PottersWheelBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)NonNullList.withSize((int)1, (Object)pottersWheel.getItem()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.POTTERS_WHEEL))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 11.0f, 12.0f, 14.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(1.0f, 11.0f, 13.0f, 14.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 11.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(2.0f, 11.0f, 14.0f, 14.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 14.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 12.0f, 12.0f).texture("#1").cullface(direction);
                }
            }
        }).from(2.0f, 0.0f, 2.0f).to(14.0f, 3.0f, 14.0f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.0f, 0.0f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(3.0f, 0.0f, 11.0f, 3.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(1.0f, 0.0f, 9.0f, 3.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 0.0f, 12.0f, 3.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(5.0f, 0.0f, 13.0f, 3.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(8.0f, 3.0f, 16.0f, 11.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 1.0f, 8.0f, 9.0f).texture("#1");
                }
            }
        }).from(4.0f, 11.0f, 4.0f).to(12.0f, 14.0f, 12.0f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.0f, 11.0f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 3.0f, 2.0f, 11.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 3.0f, 4.0f, 11.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 3.0f, 6.0f, 11.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(6.0f, 3.0f, 8.0f, 11.0f).texture("#0");
                }
            }
        }).from(7.0f, 3.0f, 7.0f).to(9.0f, 11.0f, 9.0f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(7.0f, 3.0f, 8.0f).end().end()).texture("particle", Utils.mcBlockLoc("oak_planks"))).texture("0", Utils.modBlockLoc("potters_wheel"))).texture("1", Utils.mcBlockLoc("oak_planks"));
        provider.getVariantBuilder((Block)YTechBlocks.POTTERS_WHEEL.get()).forAllStates(arg_0 -> PottersWheelBlock.lambda$registerModel$3((ModelFile)model, arg_0));
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.POTTERS_WHEEL))).parent((ModelFile)model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerModel$3(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }
}

