/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.block_entity.BrickChimneyBlockEntity;
import com.yanny.ytech.configuration.block_entity.MachineBlockEntity;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPrimitiveMachineBlockEntity
extends MachineBlockEntity {
    public static final int TEMP_PER_CHIMNEY = 50;
    private static final RandomSource RANDOM = RandomSource.create((long)42L);
    private static final String TAG_ITEMS = "items";
    private static final String TAG_SMELTING_TIME = "smeltingTime";
    private static final String TAG_LEFT_SMELTING = "smeltingLeft";
    private static final String TAG_RECIPE_TEMPERATURE = "recipeTemperature";
    private static final String TAG_BURNING_TIME = "burningTime";
    private static final String TAG_LEFT_BURNING = "burningLeft";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_NR_CHIMNEY = "nrChimney";
    private static final int BASE_MAX_TEMPERATURE = 900;
    private static final int BASE_MIN_TEMPERATURE = 20;
    private final RecipeType<?> recipeType;
    private int nrChimney = -1;
    private int burningTime = 0;
    private int leftBurningTime = 0;
    protected int temperature = 0;
    protected int leftSmelting = 0;
    protected int smeltingTime = 0;
    protected int recipeTemperature = 0;

    public AbstractPrimitiveMachineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState, RecipeType<?> recipeType) {
        super(blockEntityType, pos, blockState);
        this.recipeType = recipeType;
    }

    @Override
    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull MachineBlockEntity blockEntity) {
        boolean isBurning = false;
        int maxTemperature = this.getMaxTemperature();
        AtomicBoolean hasChanged = new AtomicBoolean(false);
        if (!this.hasActiveRecipe()) {
            if (this.hasItemsInInput()) {
                this.startRecipe(hasChanged);
            }
        } else if (this.temperature >= this.recipeTemperature) {
            if (this.leftSmelting > 0) {
                --this.leftSmelting;
            } else {
                this.finishRecipe();
            }
            hasChanged.set(true);
        }
        if (this.leftBurningTime > 0) {
            --this.leftBurningTime;
            isBurning = true;
            hasChanged.set(true);
        } else {
            ItemStack fuel = this.itemStackHandler.getStackInSlot(this.getFuelSlot());
            if (!fuel.isEmpty() && (this.hasItemsInInput() && this.isValidRecipeInInput() || this.hasActiveRecipe())) {
                ItemStack craftingRemainder = fuel.getCraftingRemainder();
                this.leftBurningTime = this.burningTime = fuel.getBurnTime(this.recipeType, level.fuelValues());
                isBurning = true;
                if (!craftingRemainder.isEmpty()) {
                    this.itemStackHandler.setStackInSlot(this.getFuelSlot(), craftingRemainder);
                }
                fuel.shrink(1);
                this.setLitState(level, blockState, pos, true);
            } else {
                this.setLitState(level, blockState, pos, false);
            }
        }
        int oldTemperature = this.temperature;
        if (isBurning && maxTemperature > this.temperature) {
            this.temperature = Math.min(maxTemperature, this.temperature + 1);
        } else if (!isBurning || maxTemperature < this.temperature) {
            this.temperature = Math.max(20, this.temperature - 1);
        }
        if (this.temperature != oldTemperature) {
            hasChanged.set(true);
        }
        if (hasChanged.get()) {
            AbstractPrimitiveMachineBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
        }
    }

    @Override
    public void tickClient(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull MachineBlockEntity blockEntity) {
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue() && RANDOM.nextInt(Math.max(Math.round(4.0f - (float)this.nrChimney / 2.0f), 1)) == 0) {
            for (int i = 0; i < RANDOM.nextInt(2) + 2; ++i) {
                AbstractPrimitiveMachineBlockEntity.makeParticles(level, pos, this.nrChimney);
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide && this.nrChimney == -1) {
            this.nrChimney = this.detectChimneys(this.level);
            AbstractPrimitiveMachineBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (this.level == null || !this.level.isClientSide) {
            if (tag.contains(TAG_ITEMS)) {
                this.itemStackHandler.deserializeNBT(provider, tag.getCompound(TAG_ITEMS));
            }
            if (tag.contains(TAG_NR_CHIMNEY)) {
                this.nrChimney = tag.getInt(TAG_NR_CHIMNEY);
            }
            this.burningTime = tag.getInt(TAG_BURNING_TIME);
            this.leftBurningTime = tag.getInt(TAG_LEFT_BURNING);
            this.smeltingTime = tag.getInt(TAG_SMELTING_TIME);
            this.leftSmelting = tag.getInt(TAG_LEFT_SMELTING);
            this.temperature = tag.getInt(TAG_TEMPERATURE);
            this.recipeTemperature = tag.getInt(TAG_RECIPE_TEMPERATURE);
        } else {
            this.nrChimney = tag.getInt(TAG_NR_CHIMNEY);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt(TAG_NR_CHIMNEY, this.nrChimney);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    @NotNull
    public ContainerData createContainerData() {
        return new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> Math.round((float)AbstractPrimitiveMachineBlockEntity.this.leftBurningTime / (float)AbstractPrimitiveMachineBlockEntity.this.burningTime * 100.0f);
                    case 1 -> AbstractPrimitiveMachineBlockEntity.this.getMaxTemperature();
                    case 2 -> AbstractPrimitiveMachineBlockEntity.this.temperature;
                    case 3 -> {
                        if (AbstractPrimitiveMachineBlockEntity.this.leftSmelting > 0) {
                            yield Math.round((float)(AbstractPrimitiveMachineBlockEntity.this.smeltingTime - AbstractPrimitiveMachineBlockEntity.this.leftSmelting) / (float)AbstractPrimitiveMachineBlockEntity.this.smeltingTime * 100.0f);
                        }
                        yield 0;
                    }
                    case 4 -> {
                        if (AbstractPrimitiveMachineBlockEntity.this.hasActiveRecipe()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 5 -> {
                        if (((Boolean)AbstractPrimitiveMachineBlockEntity.this.getBlockState().getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> throw new IllegalStateException("Invalid index");
                };
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 6;
            }
        };
    }

    public void onRemove() {
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this.worldPosition.above())) instanceof BrickChimneyBlockEntity) {
            BrickChimneyBlockEntity chimney = (BrickChimneyBlockEntity)blockEntity;
            chimney.onRemove();
        }
    }

    public int temperature() {
        return this.temperature;
    }

    public int progress() {
        return Math.round((float)(this.smeltingTime - this.leftSmelting) / (float)this.smeltingTime * 100.0f);
    }

    public void chimneyAdded() {
        if (this.level != null) {
            ++this.nrChimney;
            AbstractPrimitiveMachineBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void chimneyRemoved() {
        if (this.level != null) {
            --this.nrChimney;
            AbstractPrimitiveMachineBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.level == null || !this.level.isClientSide) {
            tag.put(TAG_ITEMS, (Tag)this.itemStackHandler.serializeNBT(provider));
            tag.putInt(TAG_NR_CHIMNEY, this.nrChimney);
            tag.putInt(TAG_BURNING_TIME, this.burningTime);
            tag.putInt(TAG_LEFT_BURNING, this.leftBurningTime);
            tag.putInt(TAG_SMELTING_TIME, this.smeltingTime);
            tag.putInt(TAG_LEFT_SMELTING, this.leftSmelting);
            tag.putInt(TAG_TEMPERATURE, this.temperature);
            tag.putInt(TAG_RECIPE_TEMPERATURE, this.recipeTemperature);
        } else {
            tag.putInt(TAG_NR_CHIMNEY, this.nrChimney);
        }
    }

    protected abstract boolean hasItemsInInput();

    protected abstract int getFuelSlot();

    protected abstract void startRecipe(@NotNull AtomicBoolean var1);

    protected abstract void finishRecipe();

    public abstract boolean hasActiveRecipe();

    protected abstract boolean isValidRecipeInInput();

    private void setLitState(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockPos pos, boolean lit) {
        if (lit != (Boolean)blockState.getValue((Property)BlockStateProperties.LIT)) {
            BlockState newState = (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(lit));
            level.setBlock(pos, newState, 3);
            AbstractPrimitiveMachineBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)newState);
        }
    }

    private int detectChimneys(@NotNull Level level) {
        BlockEntity blockEntity;
        int nrChimney = 0;
        BlockPos.MutableBlockPos blockPos = this.worldPosition.mutable();
        while ((blockEntity = level.getBlockEntity((BlockPos)(blockPos = blockPos.above()))) instanceof BrickChimneyBlockEntity) {
            BrickChimneyBlockEntity blockEntity2 = (BrickChimneyBlockEntity)blockEntity;
            ++nrChimney;
            blockEntity2.setMaster(this.worldPosition);
        }
        return nrChimney;
    }

    private int getMaxTemperature() {
        return 900 + this.nrChimney * 50;
    }

    private static void makeParticles(@NotNull Level level, @NotNull BlockPos pos, int offset) {
        level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, (double)pos.getX() + 0.5 + RANDOM.nextDouble() / 3.0 * (double)(RANDOM.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.5 + (double)offset + RANDOM.nextDouble() + RANDOM.nextDouble(), (double)pos.getZ() + 0.5 + RANDOM.nextDouble() / 3.0 * (double)(RANDOM.nextBoolean() ? 1 : -1), 0.0, 0.07 + 0.02 * (double)offset, 0.0);
    }
}

