/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.AqueductConsumerBlock;
import com.yanny.ytech.configuration.block_entity.AqueductConsumerBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.ticket.AABBTicket;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class AqueductHydratorBlockEntity
extends AqueductConsumerBlockEntity {
    private static final String TAG_TIMER = "timer";
    protected int timer = 0;
    private AABBTicket ticket = null;

    public AqueductHydratorBlockEntity(@NotNull BlockEntityType<? extends BlockEntity> entityType, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        super(entityType, pos, blockState);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.timer = tag.getInt(TAG_TIMER);
    }

    @Override
    public void tick(@NotNull ServerLevel level) {
        if (this.ticket == null) {
            this.ticket = this.createTicket(level);
        }
        if (!(this.isHydrating() && this.timer != 0 || level.getGameTime() % 20L != 0L)) {
            if (this.drainLiquid(level)) {
                BlockState blockState = (BlockState)this.getBlockState().setValue((Property)AqueductConsumerBlock.ACTIVATED, (Comparable)Boolean.valueOf(true));
                if (this.ticket == null) {
                    this.ticket = this.createTicket(level);
                } else {
                    this.ticket.validate();
                }
                this.timer = YTechMod.CONFIGURATION.getHydratorDrainPerNthTick();
                level.setBlock(this.worldPosition, blockState, 3);
                YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
            }
        } else if (this.timer > 0) {
            --this.timer;
            if (this.timer == 0) {
                if (!this.drainLiquid(level)) {
                    BlockState blockState = (BlockState)this.getBlockState().setValue((Property)AqueductConsumerBlock.ACTIVATED, (Comparable)Boolean.valueOf(false));
                    if (this.ticket != null) {
                        this.ticket.invalidate();
                    }
                    level.setBlock(this.worldPosition, blockState, 3);
                    YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
                } else {
                    this.timer = YTechMod.CONFIGURATION.getHydratorDrainPerNthTick();
                }
            } else {
                AqueductHydratorBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
            }
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt(TAG_TIMER, this.timer);
    }

    protected boolean drainLiquid(@NotNull ServerLevel level) {
        IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(this);
        if (network != null) {
            int amount = YTechMod.CONFIGURATION.getHydratorDrainAmount();
            if (network.getFluidHandler().drain(new FluidStack((Fluid)Fluids.WATER, amount), IFluidHandler.FluidAction.SIMULATE).getAmount() == amount) {
                network.getFluidHandler().drain(new FluidStack((Fluid)Fluids.WATER, amount), IFluidHandler.FluidAction.EXECUTE);
                AqueductHydratorBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
                return true;
            }
        }
        return false;
    }

    private AABBTicket createTicket(ServerLevel level) {
        return FarmlandWaterManager.addAABBTicket((Level)level, (AABB)AABB.ofSize((Vec3)this.worldPosition.getCenter(), (double)9.0, (double)1.0, (double)9.0));
    }
}

