/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.block_entity.SimpleProgressHandler;
import com.yanny.ytech.configuration.recipe.HammeringRecipe;
import com.yanny.ytech.configuration.recipe.YTechRecipeInput;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import com.yanny.ytech.registration.YTechSoundEvents;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BronzeAnvilBlockEntity
extends BlockEntity {
    private final SimpleProgressHandler<YTechRecipeInput, HammeringRecipe> progressHandler = new SimpleProgressHandler((RecipeType)YTechRecipeTypes.HAMMERING.get());

    public BronzeAnvilBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.BRONZE_ANVIL.get(), pos, blockState);
    }

    public int getProgress() {
        return this.progressHandler.getProgress();
    }

    public ItemStack getItem() {
        return this.progressHandler.getItem();
    }

    public InteractionResult onUse(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack holdingItemStack = player.getItemInHand(hand);
            if (this.progressHandler.isEmpty()) {
                if (!this.progressHandler.setupCrafting(serverLevel, holdingItemStack, HammeringRecipe::hitCount, xva$0 -> new YTechRecipeInput((ItemStack)xva$0))) {
                    this.progressHandler.setupCrafting(serverLevel, player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND), HammeringRecipe::hitCount, xva$0 -> new YTechRecipeInput((ItemStack)xva$0));
                }
            } else {
                Function<HammeringRecipe, Boolean> canProcess = recipe -> recipe.tool().items().isEmpty() || recipe.tool().test(holdingItemStack);
                Function<HammeringRecipe, Float> getStep = recipe -> Float.valueOf(1.0f);
                BiConsumer<YTechRecipeInput, HammeringRecipe> onFinish = (container, recipe) -> Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)recipe.assemble((YTechRecipeInput)container, (HolderLookup.Provider)level.registryAccess()));
                Function<ItemStack, YTechRecipeInput> getContainer = item -> new YTechRecipeInput((ItemStack)item, holdingItemStack);
                if (!this.progressHandler.tick(serverLevel, canProcess, getStep, onFinish, getContainer)) {
                    Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)hitResult.getDirection(), (ItemStack)this.progressHandler.getItem());
                    this.progressHandler.clear();
                } else {
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    level.playSound(null, pos, (SoundEvent)YTechSoundEvents.BRONZE_ANVIL_USE.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                }
            }
            level.sendBlockUpdated(pos, state, state, 3);
            level.blockEntityChanged(pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.progressHandler.load(tag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.progressHandler.save(tag, provider);
    }
}

