/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.MachineBlockEntity;
import com.yanny.ytech.configuration.container.StrainerContainerMenu;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrainerBlockEntity
extends MachineBlockEntity {
    public StrainerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.STRAINER.get(), pPos, pBlockState);
    }

    public boolean hasMesh() {
        return !this.itemStackHandler.getStackInSlot(0).isEmpty();
    }

    public void onRandomTick(ServerLevel serverLevel, BlockPos pos) {
        BlockState aboveState = serverLevel.getBlockState(pos.above());
        if (aboveState.is(Blocks.WATER) && !aboveState.getFluidState().isSource()) {
            float flowingLevel = ((Integer)aboveState.getFluidState().getValue((Property)BlockStateProperties.LEVEL_FLOWING)).intValue();
            if (serverLevel.random.nextDouble() <= (double)(flowingLevel / 7.0f)) {
                MinecraftServer server = serverLevel.getServer();
                LootTable table = server.reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Utils.modLoc("fishing/strainer")));
                ItemStack mesh = this.itemStackHandler.getStackInSlot(0);
                ObjectArrayList randomItems = table.getRandomItems(new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()).withParameter(LootContextParams.TOOL, (Object)this.itemStackHandler.getStackInSlot(0)).create(LootContextParamSets.FISHING));
                mesh.hurtAndBreak(1, serverLevel, null, item -> {});
                this.itemStackHandler.setStackInSlot(0, mesh);
                this.itemStackHandler.outputOperation(() -> randomItems.forEach(itemStack -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStackHandler, (ItemStack)itemStack, (boolean)false)));
            }
        }
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        MachineItemStackHandler.Builder builder = new MachineItemStackHandler.Builder().addInputSlot(26, 34, (handler, slot, stack) -> stack.is(YTechItemTags.MESHES.tag)).setOnChangeListener(this::onChanged);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                builder.addOutputSlot(8 + (x + 4) * 18, 16 + y * 18);
            }
        }
        return builder.build();
    }

    @Override
    @NotNull
    public ContainerData createContainerData() {
        return new SimpleContainerData(0);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.ytech.strainer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new StrainerContainerMenu(windowId, inventory.player, this.worldPosition, this.itemStackHandler, this.containerData);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void onChanged() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.level.blockEntityChanged(this.worldPosition);
        }
    }
}

