/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.YTechMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WildAnimalEntity
extends Animal {
    private static final EntityDataAccessor<Integer> DATA_GENERATION_ID = SynchedEntityData.defineId(WildAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final String TAG_GENERATION = "Generation";

    protected WildAnimalEntity(EntityType<? extends WildAnimalEntity> entityType, Level level) {
        super(entityType, level);
    }

    abstract EntityType<? extends AgeableMob> getDomesticBreedOffspring();

    public int getGeneration() {
        return (Integer)this.entityData.get(DATA_GENERATION_ID);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob parent) {
        WildAnimalEntity parentAnimal;
        int nextGeneration;
        if (parent instanceof WildAnimalEntity && (nextGeneration = WildAnimalEntity.getNextGeneration(this, parentAnimal = (WildAnimalEntity)parent)) > YTechMod.CONFIGURATION.getMinBreedingGenerations() && this.random.nextDouble() < (double)(nextGeneration - YTechMod.CONFIGURATION.getMinBreedingGenerations()) * YTechMod.CONFIGURATION.getDomesticChance()) {
            return (AgeableMob)this.getDomesticBreedOffspring().create((Level)serverLevel, EntitySpawnReason.BREEDING);
        }
        return (AgeableMob)this.getType().create((Level)serverLevel, EntitySpawnReason.BREEDING);
    }

    public void finalizeSpawnChildFromBreeding(@NotNull ServerLevel level, @NotNull Animal parent, @Nullable AgeableMob baby) {
        if (baby instanceof WildAnimalEntity) {
            WildAnimalEntity childAnimal = (WildAnimalEntity)baby;
            if (parent instanceof WildAnimalEntity) {
                WildAnimalEntity parentAnimal = (WildAnimalEntity)parent;
                childAnimal.entityData.set(DATA_GENERATION_ID, (Object)WildAnimalEntity.getNextGeneration(this, parentAnimal));
            }
        }
        super.finalizeSpawnChildFromBreeding(level, parent, baby);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt(TAG_GENERATION, this.getGeneration());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_GENERATION_ID, (Object)tag.getInt(TAG_GENERATION));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_GENERATION_ID, (Object)0);
    }

    private static int getNextGeneration(@NotNull WildAnimalEntity parent1, @NotNull WildAnimalEntity parent2) {
        return (int)Math.ceil((float)(parent1.getGeneration() + parent2.getGeneration()) / 2.0f + 1.0f);
    }
}

