/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.configuration.entity.WildDangerousEntity;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechSoundEvents;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WoollyMammothEntity
extends WildDangerousEntity {
    public WoollyMammothEntity(EntityType<? extends WildDangerousEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public EntityType<? extends AgeableMob> getDomesticBreedOffspring() {
        return null;
    }

    @Override
    public Class<? extends WildDangerousEntity> getMineClass() {
        return WoollyMammothEntity.class;
    }

    public boolean isFood(@NotNull ItemStack pStack) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)YTechSoundEvents.WOOLLY_MAMMOTH_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)YTechSoundEvents.WOOLLY_MAMMOTH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)YTechSoundEvents.WOOLLY_MAMMOTH_DEATH.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(YTechItemTags.WOOLLY_MAMMOTH_TEMP_ITEMS)), false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerTargetGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ARMOR, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.TEMPT_RANGE, 10.0);
    }
}

