/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.goal;

import com.yanny.ytech.configuration.goal.IRaidGarden;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class RaidGardenGoal<T extends PathfinderMob>
extends MoveToBlockGoal {
    @NotNull
    private final T animal;
    private final TagKey<Block> raidBlocks;
    private boolean wantsToRaid;
    private boolean canRaid;

    public RaidGardenGoal(@NotNull T animal, TagKey<Block> raidBlocks) {
        super(animal, (double)0.7f, 16);
        this.animal = animal;
        this.raidBlocks = raidBlocks;
    }

    public boolean canUse() {
        Level level;
        if (this.nextStartTick <= 0 && (level = this.animal.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!EventHooks.canEntityGrief((ServerLevel)serverLevel, this.animal)) {
                return false;
            }
            this.canRaid = false;
            this.wantsToRaid = ((IRaidGarden)this.animal).wantsMoreFood();
        }
        return super.canUse();
    }

    public boolean canContinueToUse() {
        return this.canRaid && super.canContinueToUse();
    }

    public void tick() {
        super.tick();
        this.animal.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() + 1), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.animal.getMaxHeadXRot());
        if (this.isReachedTarget()) {
            Level level = this.animal.level();
            BlockPos pos = this.blockPos.above();
            BlockState blockState = level.getBlockState(pos);
            if (this.canRaid && blockState.is(this.raidBlocks)) {
                blockState.getOptionalValue((Property)CropBlock.AGE).ifPresentOrElse(age -> {
                    if (age == 0) {
                        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                        level.destroyBlock(pos, true, this.animal);
                    } else {
                        level.setBlock(pos, (BlockState)blockState.setValue((Property)CarrotBlock.AGE, (Comparable)Integer.valueOf(age - 1)), 2);
                        level.levelEvent(2001, pos, Block.getId((BlockState)blockState));
                    }
                }, () -> {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                    level.destroyBlock(pos, true, this.animal);
                });
                ((IRaidGarden)this.animal).setWantsMoreFoodTicks();
            }
            this.canRaid = false;
            this.nextStartTick = 10;
        }
    }

    protected boolean isValidTarget(@NotNull LevelReader level, @NotNull BlockPos pos) {
        BlockState state;
        if (this.wantsToRaid && !this.canRaid && (state = level.getBlockState(pos.above())).is(this.raidBlocks)) {
            this.canRaid = true;
            return true;
        }
        return false;
    }
}

