/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.data_component.BasketContents;
import com.yanny.ytech.configuration.tooltip.BasketTooltip;
import com.yanny.ytech.registration.YTechDataComponentTypes;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class BasketItem
extends Item {
    public static final ResourceLocation FILLED_PREDICATE = Utils.modLoc("filled");
    private static final int FULL_BAR_COLOR = ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)0.33f, (float)0.33f);
    private static final int BAR_COLOR = ARGB.colorFromFloat((float)1.0f, (float)0.44f, (float)0.53f, (float)1.0f);

    public BasketItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY));
    }

    public static float getFullnessDisplay(@NotNull ItemStack stack) {
        BasketContents basketContents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return basketContents.weight().floatValue();
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        BasketContents basketContents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (basketContents != null && stack.getCount() == 1) {
            ItemStack itemStack = slot.getItem();
            BasketContents.Mutable mutable = new BasketContents.Mutable(basketContents);
            if (action == ClickAction.PRIMARY && !itemStack.isEmpty()) {
                if (mutable.tryTransfer(slot, player) > 0) {
                    BasketItem.playInsertSound((Entity)player);
                } else {
                    BasketItem.playInsertFailSound((Entity)player);
                }
                stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)mutable.toImmutable());
                this.broadcastChangesOnContainerMenu(player);
                return true;
            }
            if (action == ClickAction.SECONDARY && itemStack.isEmpty()) {
                ItemStack itemStack1 = mutable.removeOne();
                if (itemStack1 != null) {
                    ItemStack itemStack2 = slot.safeInsert(itemStack1);
                    if (itemStack2.getCount() > 0) {
                        mutable.tryInsert(itemStack2);
                    } else {
                        BasketItem.playRemoveOneSound((Entity)player);
                    }
                }
                stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)mutable.toImmutable());
                this.broadcastChangesOnContainerMenu(player);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.PRIMARY && other.isEmpty()) {
            BasketItem.toggleSelectedItem(stack, -1);
            return false;
        }
        BasketContents basketContents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (basketContents == null) {
            return false;
        }
        BasketContents.Mutable basketContents$mutable = new BasketContents.Mutable(basketContents);
        if (action == ClickAction.PRIMARY && !other.isEmpty()) {
            if (slot.allowModification(player) && basketContents$mutable.tryInsert(other) > 0) {
                BasketItem.playInsertSound((Entity)player);
            } else {
                BasketItem.playInsertFailSound((Entity)player);
            }
            stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)basketContents$mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        if (action == ClickAction.SECONDARY && other.isEmpty()) {
            ItemStack itemstack;
            if (slot.allowModification(player) && (itemstack = basketContents$mutable.removeOne()) != null) {
                BasketItem.playRemoveOneSound((Entity)player);
                access.set(itemstack);
            }
            stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)basketContents$mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        BasketItem.toggleSelectedItem(stack, -1);
        return false;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS_SERVER;
    }

    private void dropContent(Level level, Player player, ItemStack stack) {
        if (this.dropContent(stack, player)) {
            BasketItem.playDropContentsSound(level, (Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        BasketContents contents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return contents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        BasketContents contents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)contents.weight(), (int)12), 13);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        BasketContents basketContents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return basketContents.weight().compareTo(Fraction.ONE) >= 0 ? FULL_BAR_COLOR : BAR_COLOR;
    }

    public static void toggleSelectedItem(ItemStack stack, int index) {
        BasketContents basketContents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (basketContents != null) {
            BasketContents.Mutable mutable = new BasketContents.Mutable(basketContents);
            mutable.toggleSelectedItem(index);
            stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)mutable.toImmutable());
        }
    }

    public static boolean hasSelectedItem(ItemStack stack) {
        BasketContents basketContents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return basketContents.getSelectedItem() != -1;
    }

    public static int getSelectedItem(ItemStack stack) {
        BasketContents basketContents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return basketContents.getSelectedItem();
    }

    public static ItemStack getSelectedItemStack(ItemStack stack) {
        BasketContents basketContents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return basketContents.getItemUnsafe(basketContents.getSelectedItem());
    }

    public static int getNumberOfItemsToShow(ItemStack stack) {
        BasketContents basketContents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return basketContents.getNumberOfItemsToShow();
    }

    private boolean dropContent(@NotNull ItemStack stack, @NotNull Player player) {
        BasketContents contents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (contents != null && !contents.isEmpty()) {
            Optional<ItemStack> optional = BasketItem.removeOneItemFromBasket(stack, player, contents);
            if (optional.isPresent()) {
                player.drop(optional.get(), true);
                return true;
            }
            return false;
        }
        return false;
    }

    private static Optional<ItemStack> removeOneItemFromBasket(ItemStack stack, Player player, BasketContents contents) {
        BasketContents.Mutable mutable = new BasketContents.Mutable(contents);
        ItemStack itemStack = mutable.removeOne();
        if (itemStack != null) {
            BasketItem.playRemoveOneSound((Entity)player);
            stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)mutable.toImmutable());
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    public void onUseTick(Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int tick) {
        if (!level.isClientSide && entity instanceof Player) {
            boolean flag;
            Player player = (Player)entity;
            int i = this.getUseDuration(stack, entity);
            boolean bl = flag = tick == i;
            if (flag || tick < i - 10 && tick % 2 == 0) {
                this.dropContent(level, player, stack);
            }
        }
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 200;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS)).map(BasketTooltip::new) : Optional.empty();
    }

    public void onDestroyed(@NotNull ItemEntity itemEntity) {
        BasketContents basketContents = (BasketContents)itemEntity.getItem().get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (basketContents != null) {
            itemEntity.getItem().set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, basketContents.itemsCopy());
        }
    }

    private static void playRemoveOneSound(@NotNull Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertSound(@NotNull Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertFailSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private static void playDropContentsSound(Level level, @NotNull Entity entity) {
        level.playSound(null, entity.blockPosition(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.PLAYERS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void broadcastChangesOnContainerMenu(Player player) {
        player.containerMenu.slotsChanged((Container)player.getInventory());
    }
}

