/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechRecipeBookCategories;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockHitRecipe(Ingredient ingredient, Ingredient block, ItemStack result) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput recipeInput, @NotNull Level level) {
        return this.ingredient.test(recipeInput.getItem(0)) && this.block.test(recipeInput.getItem(1));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput recipeInput, @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<BlockHitRecipe> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.BLOCK_HIT.get();
    }

    @NotNull
    public RecipeType<BlockHitRecipe> getType() {
        return (RecipeType)YTechRecipeTypes.BLOCK_HIT.get();
    }

    @NotNull
    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)YTechRecipeBookCategories.BLOCK_HIT.get();
    }

    public static class Builder
    implements RecipeBuilder {
        private final Ingredient ingredient;
        private final Ingredient block;
        private final Item result;
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        Builder(@NotNull Ingredient ingredient, @NotNull Ingredient block, @NotNull Item result) {
            this.ingredient = ingredient;
            this.block = block;
            this.result = result;
        }

        public static Builder blockUse(@NotNull HolderGetter<Item> items, @NotNull ItemLike input, TagKey<Item> block, @NotNull Item result) {
            return new Builder(Ingredient.of((ItemLike)input), Ingredient.of((HolderSet)items.getOrThrow(block)), result);
        }

        @NotNull
        public Builder unlockedBy(@NotNull String criterionName, @NotNull Criterion criterionTrigger) {
            this.criteria.put(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public Builder group(@Nullable String groupName) {
            return this;
        }

        @NotNull
        public Item getResult() {
            return this.result;
        }

        public void save(@NotNull RecipeOutput finishedRecipeConsumer, @NotNull ResourceKey<Recipe<?>> recipeId) {
            this.ensureValid(recipeId);
            Advancement.Builder builder = finishedRecipeConsumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(recipeId)).rewards(AdvancementRewards.Builder.recipe(recipeId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            finishedRecipeConsumer.accept(recipeId, (Recipe)new BlockHitRecipe(this.ingredient, this.block, new ItemStack((ItemLike)this.result)), builder.build(Utils.modLoc("recipes/block_hit/" + recipeId.location().getPath())));
        }

        private void ensureValid(@NotNull ResourceKey<Recipe<?>> id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<BlockHitRecipe> {
        private static final MapCodec<BlockHitRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(blockHitRecipe -> blockHitRecipe.ingredient), (App)Ingredient.CODEC.fieldOf("block").forGetter(blockHitRecipe -> blockHitRecipe.block), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(blockHitRecipe -> blockHitRecipe.result)).apply((Applicative)instance, BlockHitRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, BlockHitRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<BlockHitRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BlockHitRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static BlockHitRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient block = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new BlockHitRecipe(ingredient, block, result);
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull BlockHitRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.block);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

