/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.SpearType;
import com.yanny.ytech.configuration.item.SpearItem;
import com.yanny.ytech.configuration.model.SpearModel;
import com.yanny.ytech.registration.YTechItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class YTechRenderer
extends BlockEntityWithoutLevelRenderer {
    @NotNull
    public static final BlockEntityWithoutLevelRenderer INSTANCE = new YTechRenderer();
    @NotNull
    private final ItemRenderer itemRenderer;
    private final ModelManager modelManager;
    private final Map<SpearType, SpearModel> spearModels = new HashMap<SpearType, SpearModel>();

    private YTechRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.modelManager = Minecraft.getInstance().getModelManager();
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
        for (SpearType type : SpearType.values()) {
            this.spearModels.put(type, new SpearModel(Minecraft.getInstance().getEntityModels().bakeLayer(SpearModel.LAYER_LOCATIONS.get((Object)type))));
        }
    }

    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.popPose();
        poseStack.pushPose();
        if (stack.getItem() instanceof SpearItem) {
            this.renderStatic(stack, displayContext, packedLight, packedOverlay, poseStack, buffer, (Level)Minecraft.getInstance().level, 0);
        } else {
            super.renderByItem(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    public void render(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, boolean leftHand, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay, @NotNull BakedModel bakedModel) {
        if (!stack.isEmpty()) {
            boolean is2dModel;
            poseStack.pushPose();
            boolean bl = is2dModel = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED;
            if (is2dModel) {
                for (SpearType spearType : this.spearModels.keySet()) {
                    if (!stack.is((Item)((DeferredItem)YTechItems.SPEARS.get(spearType.materialType)).get())) continue;
                    bakedModel = this.modelManager.getModel(SpearModel.MODEL_LOCATIONS.get((Object)spearType));
                    break;
                }
            }
            bakedModel = bakedModel.applyTransform(displayContext, poseStack, leftHand);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            for (Map.Entry entry : this.spearModels.entrySet()) {
                if (stack.is((Item)((DeferredItem)YTechItems.SPEARS.get(((SpearType)((Object)entry.getKey())).materialType)).get()) && !is2dModel) {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, -1.0f, -1.0f);
                    VertexConsumer vertexConsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)((SpearModel)((Object)entry.getValue())).renderType(SpearType.TEXTURE_LOCATION), (boolean)false, (boolean)stack.hasFoil());
                    ((SpearModel)((Object)entry.getValue())).renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, -1);
                    poseStack.popPose();
                    continue;
                }
                for (BakedModel model : bakedModel.getRenderPasses(stack)) {
                    for (RenderType rendertype : model.getRenderTypes(stack)) {
                        VertexConsumer vertexConsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.hasFoil());
                        this.itemRenderer.renderModelLists(model, stack, packedLight, packedOverlay, poseStack, vertexConsumer);
                    }
                }
            }
            poseStack.popPose();
        }
    }

    public void renderStatic(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, int packedLight, int packedOverlay, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, @Nullable Level pLevel, int seed) {
        boolean leftHand = displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        this.renderStatic((LivingEntity)Minecraft.getInstance().player, stack, displayContext, leftHand, poseStack, buffer, pLevel, packedLight, packedOverlay, seed);
    }

    public void renderStatic(@Nullable LivingEntity pEntity, @NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, boolean pLeftHand, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, @Nullable Level pLevel, int packedLight, int packedOverlay, int seed) {
        if (!stack.isEmpty()) {
            BakedModel bakedmodel = this.itemRenderer.getModel(stack, pLevel, pEntity, seed);
            BakedModel modelOverride = bakedmodel.overrides().findOverride(stack, (ClientLevel)pLevel, pEntity, seed);
            this.render(stack, displayContext, pLeftHand, poseStack, buffer, packedLight, packedOverlay, modelOverride == null ? bakedmodel : modelOverride);
        }
    }
}

