/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.screen.components;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.screen.components.IComponent;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class AbstractScreenHandler<T extends AbstractContainerMenu> {
    private static final ResourceLocation GUI = Utils.modLoc("textures/gui/machine.png");
    @NotNull
    private final MachineItemStackHandler itemStackHandler;
    @NotNull
    private final Set<IComponent> components;
    private int leftPos;
    private int topPos;
    private int imageWidth;
    private int imageHeight;

    private AbstractScreenHandler(@NotNull MachineItemStackHandler itemStackHandler, @NotNull Set<IComponent> components) {
        this.itemStackHandler = itemStackHandler;
        this.components = components;
    }

    public void init(@NotNull AbstractContainerScreen<T> screen) {
        this.leftPos = screen.getGuiLeft();
        this.topPos = screen.getGuiTop();
        this.imageWidth = screen.getXSize();
        this.imageHeight = screen.getYSize();
    }

    public void render(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.blit(RenderType::guiTextured, GUI, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            guiGraphics.blit(RenderType::guiTextured, GUI, this.leftPos + this.itemStackHandler.getX(i) - 1, this.topPos + this.itemStackHandler.getY(i) - 1, 7.0f, 83.0f, 18, 18, 256, 256);
        }
        this.components.forEach(component -> component.render(guiGraphics, this.leftPos, this.topPos));
    }

    public void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.components.forEach(component -> component.renderTooltip(guiGraphics, this.leftPos, this.topPos, mouseX, mouseY));
    }

    public static class Builder<T extends AbstractContainerMenu> {
        @NotNull
        final MachineItemStackHandler itemStackHandler;
        @NotNull
        final Set<IComponent> components = new LinkedHashSet<IComponent>();

        public Builder(@NotNull MachineItemStackHandler itemStackHandler) {
            this.itemStackHandler = itemStackHandler;
        }

        public Builder<T> addComponent(@NotNull IComponent component) {
            this.components.add(component);
            return this;
        }

        public AbstractScreenHandler<T> build() {
            return new AbstractScreenHandler(this.itemStackHandler, this.components);
        }
    }
}

