/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.mojang.serialization.Codec;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.YTechArmorMaterials;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.EquipmentModel;
import org.jetbrains.annotations.NotNull;

public class YTechEquipmentModelProvider
implements DataProvider {
    private final PackOutput.PathProvider path;
    private final Map<ResourceLocation, EquipmentModel> map = new HashMap<ResourceLocation, EquipmentModel>();

    public YTechEquipmentModelProvider(PackOutput output) {
        this.path = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models/equipment");
    }

    public void registerModels() {
        Utils.exclude(EnumSet.allOf(YTechArmorMaterials.class), (Enum[])new YTechArmorMaterials[]{YTechArmorMaterials.IRON, YTechArmorMaterials.GOLD}).forEach(armor -> this.add(armor.armorMaterial.modelId()));
    }

    private void add(ResourceLocation id) {
        this.add(id, EquipmentModel.builder().addHumanoidLayers(id).build());
    }

    private void add(ResourceLocation id, EquipmentModel model) {
        if (this.map.putIfAbsent(id, model) != null) {
            throw new IllegalStateException("Tried to register equipment model twice for id: " + String.valueOf(id));
        }
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        this.registerModels();
        return DataProvider.saveAll((CachedOutput)cache, (Codec)EquipmentModel.CODEC, (PackOutput.PathProvider)this.path, this.map);
    }

    @NotNull
    public String getName() {
        return "Equipment Model Definitions: ytech";
    }
}

