/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import com.yanny.ytech.configuration.recipe.BlockHitRecipe;
import com.yanny.ytech.configuration.recipe.YTechRecipeInput;
import com.yanny.ytech.registration.YTechBiomeTags;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechMobEffects;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.block.CreateFluidSourceEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EventBusSubscriber(modid="ytech", bus=EventBusSubscriber.Bus.GAME)
public class ForgeBusSubscriber {
    @NotNull
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onPlayerSpawnSet(@NotNull PlayerSetSpawnEvent event) {
        BlockPos pos = event.getNewSpawn();
        if (pos != null && event.getEntity().level().getBlockState(pos).getBlock() instanceof GrassBedBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(@NotNull LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.server().onLevelLoad(level);
        } else if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.client().onLevelLoad(level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(@NotNull LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.server().onLevelUnload(level);
        } else if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.client().onLevelUnload(level);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(@NotNull ServerStartingEvent event) {
        BuiltInRegistries.BLOCK.getTag(YTechBlockTags.REQUIRE_VALID_TOOL).ifPresent(h -> h.stream().map(Holder::value).forEach(ForgeBusSubscriber::setBlockRequireValidTool));
    }

    @SubscribeEvent
    public static void onPlayerLogIn(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        YTechMod.IRRIGATION_PROPAGATOR.server().onPlayerLogIn(event.getEntity());
    }

    @SubscribeEvent
    public static void onLevelPreTick(@NotNull LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            YTechMod.IRRIGATION_PROPAGATOR.server().getNetworks(level2).values().forEach(network -> network.tick(level2));
        }
    }

    @SubscribeEvent
    public static void onLevelPostTick(@NotNull LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            YTechMod.IRRIGATION_PROPAGATOR.server().tick(level2);
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(@NotNull ChunkWatchEvent.Watch event) {
        YTechMod.IRRIGATION_PROPAGATOR.server().onChunkWatch(event.getLevel(), event.getPlayer(), event.getChunk());
    }

    @SubscribeEvent
    public static void onPlayerLeftClickBlock(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        ItemStack heldItem = player.getMainHandItem();
        BlockState blockState = level.getBlockState(event.getPos());
        Direction direction = event.getFace();
        if (!level.isClientSide && !player.isCreative() && direction != null && event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START && event.getHand() == InteractionHand.MAIN_HAND) {
            level.getRecipeManager().getRecipeFor((RecipeType)YTechRecipeTypes.BLOCK_HIT.get(), (RecipeInput)new YTechRecipeInput(heldItem, blockState.getBlock().asItem().getDefaultInstance()), level).ifPresent(recipe -> {
                Block.popResourceFromFace((Level)level, (BlockPos)event.getPos(), (Direction)direction, (ItemStack)((BlockHitRecipe)recipe.value()).result().copy());
                heldItem.shrink(1);
            });
        }
    }

    @SubscribeEvent
    public static void onLivingBreatheEvent(@NotNull LivingBreatheEvent event) {
        if (event.getEntity().hasEffect(YTechMobEffects.ABYSS_WALKER) && event.getEntity().level().getGameTime() % 2L == 0L) {
            event.setConsumeAirAmount(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderHighlightEvent(RenderHighlightEvent.Block event) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (level != null && player != null) {
            if (level.getBlockState(event.getTarget().getBlockPos()).is((Block)YTechBlocks.CRAFTING_WORKSPACE.get())) {
                Vec3 camera = event.getCamera().getPosition();
                PoseStack poseStack = event.getPoseStack();
                ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
                int[] position = CraftingWorkspaceBlock.getPosition(event.getTarget(), itemStack.isEmpty());
                if (position == null) {
                    return;
                }
                poseStack.pushPose();
                poseStack.translate(-camera.x, -camera.y, -camera.z);
                poseStack.translate((double)position[0] / 3.0, (double)position[1] / 3.0, (double)position[2] / 3.0);
                float cR = 0.1f;
                float cG = 1.0f;
                float cB = 0.1f;
                BlockPos target = event.getTarget().getBlockPos();
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)event.getMultiBufferSource().getBuffer((RenderType)RenderType.LINES), (AABB)CraftingWorkspaceBlock.BOX.bounds().move(target), (float)cR, (float)cG, (float)cB, (float)1.0f);
                poseStack.popPose();
            } else if (level.getBlockState(event.getTarget().getBlockPos()).is((Block)YTechBlocks.WOODEN_BOX.get())) {
                Vec3 camera = event.getCamera().getPosition();
                PoseStack poseStack = event.getPoseStack();
                BlockHitResult hitResult = event.getTarget();
                int[] position = WoodenBoxBlock.getPosition(event.getTarget());
                if (position == null || hitResult.getDirection() != Direction.UP) {
                    return;
                }
                poseStack.pushPose();
                poseStack.translate(-camera.x, -camera.y, -camera.z);
                poseStack.translate(0.125 + (double)position[0] / 4.0, 0.5, 0.125 + (double)position[1] / 4.0);
                float cR = 0.1f;
                float cG = 0.1f;
                float cB = 0.1f;
                BlockPos target = event.getTarget().getBlockPos();
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)event.getMultiBufferSource().getBuffer((RenderType)RenderType.LINES), (AABB)WoodenBoxBlock.BOX.bounds().move(target), (float)cR, (float)cG, (float)cB, (float)0.5f);
                poseStack.popPose();
            }
        }
    }

    @SubscribeEvent
    public static void onCreateFluidSourceEvent(@NotNull CreateFluidSourceEvent event) {
        if (event.getState().getFluidState().is((Fluid)Fluids.WATER) && YTechMod.CONFIGURATION.hasFiniteWaterSource() && !event.getLevel().getBiome(event.getPos()).is(YTechBiomeTags.INFINITE_WATER_SOURCE_BIOMES)) {
            event.setCanConvert(false);
        }
    }

    @SubscribeEvent
    public static void onCropGrowEvent(@NotNull CropGrowEvent.Pre event) {
        BlockState blockState;
        if (YTechMod.CONFIGURATION.cropsNeedWateredFarmland() && (blockState = event.getLevel().getBlockState(event.getPos().below())).hasProperty((Property)BlockStateProperties.MOISTURE) && (Integer)blockState.getValue((Property)BlockStateProperties.MOISTURE) < 7) {
            event.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
        }
    }

    private static void setBlockRequireValidTool(@NotNull Block block) {
        try {
            BlockState blockState = (BlockState)ObfuscationReflectionHelper.getPrivateValue(Block.class, (Object)block, (String)"defaultBlockState");
            if (blockState != null) {
                ObfuscationReflectionHelper.setPrivateValue(BlockBehaviour.BlockStateBase.class, (Object)blockState, (Object)Boolean.TRUE, (String)"requiresCorrectToolForDrops");
            }
            LOGGER.info("Set requiresCorrectToolForDrops on {}", (Object)Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to set requiresCorrectToolForDrops on block {}: {}", (Object)Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)), (Object)e.getMessage());
        }
    }
}

