/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.compatibility.CuriosCapability;
import com.yanny.ytech.compatibility.TopCompatibility;
import com.yanny.ytech.configuration.SpearType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.WellPulleyBlockEntity;
import com.yanny.ytech.configuration.data_component.BasketContents;
import com.yanny.ytech.configuration.entity.AurochsEntity;
import com.yanny.ytech.configuration.entity.DeerEntity;
import com.yanny.ytech.configuration.entity.FowlEntity;
import com.yanny.ytech.configuration.entity.GoAroundEntity;
import com.yanny.ytech.configuration.entity.MouflonEntity;
import com.yanny.ytech.configuration.entity.SaberToothTigerEntity;
import com.yanny.ytech.configuration.entity.TerrorBirdEntity;
import com.yanny.ytech.configuration.entity.WildBoarEntity;
import com.yanny.ytech.configuration.entity.WoollyMammothEntity;
import com.yanny.ytech.configuration.entity.WoollyRhinoEntity;
import com.yanny.ytech.configuration.item.BasketItem;
import com.yanny.ytech.configuration.item.DiviningRodItem;
import com.yanny.ytech.configuration.item.SpearItem;
import com.yanny.ytech.configuration.model.AurochsModel;
import com.yanny.ytech.configuration.model.CustomRendererBakedModel;
import com.yanny.ytech.configuration.model.DeerModel;
import com.yanny.ytech.configuration.model.FowlModel;
import com.yanny.ytech.configuration.model.MouflonModel;
import com.yanny.ytech.configuration.model.SaberToothTigerModel;
import com.yanny.ytech.configuration.model.SpearModel;
import com.yanny.ytech.configuration.model.TerrorBirdModel;
import com.yanny.ytech.configuration.model.WildBoarModel;
import com.yanny.ytech.configuration.model.WoollyMammothModel;
import com.yanny.ytech.configuration.model.WoollyRhinoModel;
import com.yanny.ytech.configuration.renderer.AqueductRenderer;
import com.yanny.ytech.configuration.renderer.AurochsRenderer;
import com.yanny.ytech.configuration.renderer.BronzeAnvilRenderer;
import com.yanny.ytech.configuration.renderer.CraftingWorkspaceRenderer;
import com.yanny.ytech.configuration.renderer.DeerRenderer;
import com.yanny.ytech.configuration.renderer.DryingRackRenderer;
import com.yanny.ytech.configuration.renderer.FirePitRenderer;
import com.yanny.ytech.configuration.renderer.FowlRenderer;
import com.yanny.ytech.configuration.renderer.GoAroundRenderer;
import com.yanny.ytech.configuration.renderer.MillstoneRenderer;
import com.yanny.ytech.configuration.renderer.MouflonRenderer;
import com.yanny.ytech.configuration.renderer.PottersWheelRenderer;
import com.yanny.ytech.configuration.renderer.SaberToothTigerRenderer;
import com.yanny.ytech.configuration.renderer.SpearRenderer;
import com.yanny.ytech.configuration.renderer.StrainerRenderer;
import com.yanny.ytech.configuration.renderer.TanningRackRenderer;
import com.yanny.ytech.configuration.renderer.TerrorBirdRenderer;
import com.yanny.ytech.configuration.renderer.ToolRackRenderer;
import com.yanny.ytech.configuration.renderer.TreeStumpRenderer;
import com.yanny.ytech.configuration.renderer.WildBoarRenderer;
import com.yanny.ytech.configuration.renderer.WoodenBoxRenderer;
import com.yanny.ytech.configuration.renderer.WoollyMammothRenderer;
import com.yanny.ytech.configuration.renderer.WoollyRhinoRenderer;
import com.yanny.ytech.configuration.renderer.YTechRenderer;
import com.yanny.ytech.configuration.screen.AqueductFertilizerScreen;
import com.yanny.ytech.configuration.screen.PrimitiveAlloySmelterScreen;
import com.yanny.ytech.configuration.screen.PrimitiveSmelterScreen;
import com.yanny.ytech.configuration.screen.StrainerScreen;
import com.yanny.ytech.configuration.tooltip.ClientBasketTooltip;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.network.irrigation.IrrigationUtils;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechEntityTypes;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechMenuTypes;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="ytech", bus=EventBusSubscriber.Bus.MOD)
public class ModBusSubscriber {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void commonSetupEvent(@NotNull FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCapability.register();
        }
        TopCompatibility.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientSetup(@NotNull FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)YTechItems.BASKET.get()), (ResourceLocation)BasketItem.FILLED_PREDICATE, (stack, level, entity, seed) -> BasketItem.getFullnessDisplay(stack));
            ItemProperties.register((Item)((Item)YTechItems.DIVINING_ROD.get()), (ResourceLocation)DiviningRodItem.ABUNDANCE_PREDICATE, (stack, level, entity, seed) -> entity != null ? (float)WellPulleyBlockEntity.getWaterAbundance(entity.getOnPos()) : 1.0f);
            YTechItems.SPEARS.values().forEach(item -> ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)SpearItem.THROWING_PREDICATE, (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)YTechMenuTypes.AQUEDUCT_FERTILIZER.get(), AqueductFertilizerScreen::new);
        event.register((MenuType)YTechMenuTypes.PRIMITIVE_ALLOY_SMELTER.get(), PrimitiveAlloySmelterScreen::new);
        event.register((MenuType)YTechMenuTypes.PRIMITIVE_SMELTER.get(), PrimitiveSmelterScreen::new);
        event.register((MenuType)YTechMenuTypes.STRAINER.get(), StrainerScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRegisterClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BasketContents.BasketTooltip.class, ClientBasketTooltip::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        IClientItemExtensions clientItemExtensions = new IClientItemExtensions(){

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return YTechRenderer.INSTANCE;
            }
        };
        event.registerItem(clientItemExtensions, (Item[])YTechItems.SPEARS.values().stream().map(DeferredHolder::get).toArray(Item[]::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerEntityRenderer(@NotNull EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.AQUEDUCT.get(), AqueductRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.BRONZE_ANVIL.get(), BronzeAnvilRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.DRYING_RACK.get(), DryingRackRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.CRAFTING_WORKSPACE.get(), CraftingWorkspaceRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.FIRE_PIT.get(), FirePitRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.MILLSTONE.get(), MillstoneRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.POTTERS_WHEEL.get(), PottersWheelRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.STRAINER.get(), StrainerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.TANNING_RACK.get(), TanningRackRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.TOOL_RACK.get(), ToolRackRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.TREE_STUMP.get(), TreeStumpRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)YTechBlockEntityTypes.WOODEN_BOX.get(), WoodenBoxRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.FLINT_SPEAR.get(), context -> new SpearRenderer(context, SpearModel.LAYER_LOCATIONS.get((Object)SpearType.FLINT)));
        event.registerEntityRenderer((EntityType)YTechEntityTypes.COPPER_SPEAR.get(), context -> new SpearRenderer(context, SpearModel.LAYER_LOCATIONS.get((Object)SpearType.COPPER)));
        event.registerEntityRenderer((EntityType)YTechEntityTypes.BRONZE_SPEAR.get(), context -> new SpearRenderer(context, SpearModel.LAYER_LOCATIONS.get((Object)SpearType.BRONZE)));
        event.registerEntityRenderer((EntityType)YTechEntityTypes.IRON_SPEAR.get(), context -> new SpearRenderer(context, SpearModel.LAYER_LOCATIONS.get((Object)SpearType.IRON)));
        event.registerEntityRenderer((EntityType)YTechEntityTypes.PEBBLE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.GO_AROUND.get(), GoAroundRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.AUROCHS.get(), AurochsRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.DEER.get(), DeerRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.FOWL.get(), FowlRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.MOUFLON.get(), MouflonRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.SABER_TOOTH_TIGER.get(), SaberToothTigerRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.TERROR_BIRD.get(), TerrorBirdRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.WILD_BOAR.get(), WildBoarRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.WOOLLY_MAMMOTH.get(), WoollyMammothRenderer::new);
        event.registerEntityRenderer((EntityType)YTechEntityTypes.WOOLLY_RHINO.get(), WoollyRhinoRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SpearModel.LAYER_LOCATIONS.get((Object)SpearType.BRONZE), () -> SpearModel.createLayer(0, 12));
        event.registerLayerDefinition(SpearModel.LAYER_LOCATIONS.get((Object)SpearType.COPPER), () -> SpearModel.createLayer(0, 6));
        event.registerLayerDefinition(SpearModel.LAYER_LOCATIONS.get((Object)SpearType.FLINT), () -> SpearModel.createLayer(0, 0));
        event.registerLayerDefinition(SpearModel.LAYER_LOCATIONS.get((Object)SpearType.IRON), () -> SpearModel.createLayer(0, 18));
        event.registerLayerDefinition(AurochsModel.LAYER_LOCATION, AurochsModel::createBodyLayer);
        event.registerLayerDefinition(DeerModel.LAYER_LOCATION, DeerModel::createBodyLayer);
        event.registerLayerDefinition(FowlModel.LAYER_LOCATION, FowlModel::createBodyLayer);
        event.registerLayerDefinition(MouflonModel.LAYER_LOCATION, MouflonModel::createBodyLayer);
        event.registerLayerDefinition(SaberToothTigerModel.LAYER_LOCATION, SaberToothTigerModel::createBodyLayer);
        event.registerLayerDefinition(TerrorBirdModel.LAYER_LOCATION, TerrorBirdModel::createBodyLayer);
        event.registerLayerDefinition(WildBoarModel.LAYER_LOCATION, WildBoarModel::createBodyLayer);
        event.registerLayerDefinition(WoollyMammothModel.LAYER_LOCATION, WoollyMammothModel::createBodyLayer);
        event.registerLayerDefinition(WoollyRhinoModel.LAYER_LOCATION, WoollyRhinoModel::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerModel(@NotNull ModelEvent.RegisterAdditional event) {
        for (SpearType spearType : SpearType.values()) {
            event.register(SpearModel.MODEL_IN_HAND_LOCATIONS.get((Object)spearType));
        }
        event.register(ModelResourceLocation.standalone((ResourceLocation)Utils.modBlockLoc("strainer_net")));
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)YTechEntityTypes.AUROCHS.get(), AurochsEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.DEER.get(), DeerEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.FOWL.get(), FowlEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.GO_AROUND.get(), GoAroundEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.MOUFLON.get(), MouflonEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.SABER_TOOTH_TIGER.get(), SaberToothTigerEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.TERROR_BIRD.get(), TerrorBirdEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.WILD_BOAR.get(), WildBoarEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.WOOLLY_MAMMOTH.get(), WoollyMammothEntity.createAttributes().build());
        event.put((EntityType)YTechEntityTypes.WOOLLY_RHINO.get(), WoollyRhinoEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void onSpawnPlacementRegister(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)YTechEntityTypes.AUROCHS.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.DEER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.FOWL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.MOUFLON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.SABER_TOOTH_TIGER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.TERROR_BIRD.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.WILD_BOAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.WOOLLY_MAMMOTH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YTechEntityTypes.WOOLLY_RHINO.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(EntityType.CHICKEN, ModBusSubscriber::removeAnimalPredicate, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityType.COW, ModBusSubscriber::removeAnimalPredicate, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityType.PIG, ModBusSubscriber::removeAnimalPredicate, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register(EntityType.SHEEP, ModBusSubscriber::removeAnimalPredicate, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        Stream.of(SpearType.values()).forEach(spearType -> {
            ModelResourceLocation modelLocation = SpearModel.MODEL_LOCATIONS.get(spearType);
            BakedModel existingModel = (BakedModel)modelRegistry.get(modelLocation);
            if (existingModel == null) {
                throw new RuntimeException("Missing model for " + String.valueOf(spearType));
            }
            modelRegistry.put(modelLocation, new CustomRendererBakedModel(existingModel));
        });
    }

    @SubscribeEvent
    public static void onRegisterCap(@NotNull RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)YTechBlockEntityTypes.AQUEDUCT.get(), (blockEntity, direction) -> {
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork((IIrrigationBlockEntity)blockEntity);
            if (network != null) {
                return network.getFluidHandler();
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)YTechBlockEntityTypes.AMPHORA.get(), (amphoraBlockEntity, direction) -> {
            if (!amphoraBlockEntity.isRemoved() && direction == Direction.UP) {
                return amphoraBlockEntity.getItemHandler();
            }
            return null;
        });
    }

    @SubscribeEvent
    public static void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_VERSION);
        YTechMod.IRRIGATION_PROPAGATOR = IrrigationUtils.registerIrrigationPropagator(registrar);
    }

    public static boolean removeAnimalPredicate(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return !YTechMod.CONFIGURATION.removeVanillaMobs();
    }
}

