/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.emi;

import com.yanny.ytech.compatibility.EmiCompatibility;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.recipe.DryingRecipe;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;

public class EmiDryingRecipe
extends BasicEmiRecipe {
    public static final EmiIngredient WORKSTATION = EmiIngredient.of(YTechItemTags.DRYING_RACKS.tag);
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EmiCompatibility.ref(YTechRecipeTypes.DRYING), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)((DeferredItem)YTechItems.DRYING_RACKS.get(MaterialType.OAK_WOOD)).get())), (EmiRenderable)new EmiTexture(EmiCompatibility.TEXTURE, 176, 240, 16, 16));
    private final int time;

    public EmiDryingRecipe(DryingRecipe recipe, ResourceLocation id) {
        super(CATEGORY, id, 84, 26);
        this.inputs = List.of(EmiIngredient.of((Ingredient)recipe.ingredient()));
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.result()));
        this.time = recipe.dryingTime();
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        widgetHolder.addFillingArrow(26, 5, 50 * this.time).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.time / 20.0f)}).getVisualOrderText())));
        widgetHolder.addSlot((EmiIngredient)this.inputs.get(0), 0, 4);
        widgetHolder.addSlot((EmiIngredient)this.outputs.get(0), 58, 0).large(true).recipeContext((EmiRecipe)this);
    }
}

