/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.emi;

import com.yanny.ytech.compatibility.EmiCompatibility;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.ButtonWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;

public class WorkspaceCraftingWidget
extends Widget {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final List<EmiIngredient> ingredients;
    private final List<ButtonWidget> buttonWidgets;
    private final Map<Integer, List<SlotWidget>> slotWidgets = new HashMap<Integer, List<SlotWidget>>();
    private int layer = 0;

    public WorkspaceCraftingWidget(int x, int y, int width, int height, List<EmiIngredient> ingredients) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.buttonWidgets = List.of(new ButtonWidget(x + 64, y, 12, 10, 16, 0, EmiCompatibility.TEXTURE, () -> this.layer < 3, this::upClicked), new ButtonWidget(x + 64, y + 10, 12, 10, 28, 0, EmiCompatibility.TEXTURE, () -> this.layer > 0, this::downClicked));
        for (int layer = 0; layer < 3; ++layer) {
            int i = layer * 9;
            this.slotWidgets.computeIfAbsent(layer, k -> new LinkedList());
            for (int px = 0; px < 3; ++px) {
                for (int pz = 0; pz < 3; ++pz) {
                    EmiIngredient ingredient = ingredients.get(i);
                    if (!ingredient.isEmpty()) {
                        this.slotWidgets.get(layer).add(new SlotWidget(ingredient, x + px * 18, y + 22 + pz * 18));
                    }
                    ++i;
                }
            }
        }
    }

    void upClicked(double mouseX, double mouseY, int button) {
        if (this.layer < 3) {
            ++this.layer;
        }
    }

    void downClicked(double mouseX, double mouseY, int button) {
        if (this.layer > 0) {
            --this.layer;
        }
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        for (ButtonWidget widget : this.buttonWidgets) {
            Bounds bounds = widget.getBounds();
            if (mouseX <= bounds.left() || mouseX >= bounds.right() || mouseY <= bounds.top() || mouseY >= bounds.bottom()) continue;
            return widget.mouseClicked(mouseX, mouseY, button);
        }
        if (this.layer > 0) {
            for (SlotWidget slotWidget : this.slotWidgets.get(this.layer - 1)) {
                if (!slotWidget.getBounds().contains(mouseX, mouseY)) continue;
                return slotWidget.mouseClicked(mouseX, mouseY, button);
            }
        }
        return false;
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        if (this.layer > 0) {
            for (SlotWidget slotWidget : this.slotWidgets.get(this.layer - 1)) {
                if (!slotWidget.getBounds().contains(mouseX, mouseY)) continue;
                return slotWidget.getTooltip(mouseX, mouseY);
            }
        }
        return List.of();
    }

    public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        int i = 0;
        switch (this.layer) {
            case 0: {
                for (int y = 0; y < 3; ++y) {
                    for (int z = 2; z >= 0; --z) {
                        for (int x = 0; x < 3; ++x) {
                            EmiIngredient ingredient = this.ingredients.get(i);
                            if (!ingredient.isEmpty()) {
                                draw.pose().pushPose();
                                draw.pose().translate(0.0f, 0.0f, (float)(i * 5));
                                ingredient.render(draw, this.x + 32 - x * 8 - z * 8, this.y + 74 + x * 4 - z * 4 - y * 32, delta, 1);
                                draw.pose().popPose();
                            }
                            ++i;
                        }
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                for (SlotWidget slotWidget : this.slotWidgets.get(this.layer - 1)) {
                    slotWidget.render(draw, mouseX, mouseY, delta);
                }
                draw.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"emi.workspace_crafting.layer", (Object[])new Object[]{this.layer}), this.x + 1, this.y + 1, 0, false);
            }
        }
        for (ButtonWidget widget : this.buttonWidgets) {
            widget.render(draw, mouseX, mouseY, delta);
        }
    }
}

