/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.jei;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class AnimatedTextureWidget
implements IRecipeWidget {
    protected final ScreenPosition position;
    private final ResourceLocation texture;
    private final int time;
    private final boolean horizontal;
    private final boolean endToStart;
    private final boolean fullToEmpty;
    private final int width;
    private final int height;
    private final int u;
    private final int v;
    private final int regionWidth;
    private final int regionHeight;
    private final int textureWidth;
    private final int textureHeight;

    public AnimatedTextureWidget(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, int time, boolean horizontal, boolean endToStart, boolean fullToEmpty) {
        this.texture = texture;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.time = time;
        this.horizontal = horizontal;
        this.endToStart = endToStart;
        this.fullToEmpty = fullToEmpty;
        this.position = new ScreenPosition(x, y);
    }

    public AnimatedTextureWidget(ResourceLocation texture, int x, int y, int width, int height, int u, int v, int time, boolean horizontal, boolean endToStart, boolean fullToEmpty) {
        this(texture, x, y, width, height, u, v, width, height, 256, 256, time, horizontal, endToStart, fullToEmpty);
    }

    @NotNull
    public ScreenPosition getPosition() {
        return this.position;
    }

    public void drawWidget(@NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int subTime = (int)(System.currentTimeMillis() % (long)this.time);
        int x = this.position.x();
        int y = this.position.y();
        if (this.endToStart ^ this.fullToEmpty) {
            subTime = this.time - subTime;
        }
        int mx = x;
        int my = y;
        int mw = this.width;
        int mh = this.height;
        int mu = this.u;
        int mv = this.v;
        int mrw = this.regionWidth;
        int mrh = this.regionHeight;
        if (this.horizontal) {
            if (this.endToStart) {
                mx = x + this.width * subTime / this.time;
                mu = this.u + this.regionWidth * subTime / this.time;
                mw = this.width - (mx - x);
                mrw = this.regionWidth - (mu - this.u);
            } else {
                mw = this.width * subTime / this.time;
                mrw = this.regionWidth * subTime / this.time;
            }
        } else if (this.endToStart) {
            my = y + this.height * subTime / this.time;
            mv = this.v + this.regionHeight * subTime / this.time;
            mh = this.height - (my - y);
            mrh = this.regionHeight - (mv - this.v);
        } else {
            mh = this.height * subTime / this.time;
            mrh = this.regionHeight * subTime / this.time;
        }
        guiGraphics.blit(this.texture, mx, my, mw, mh, (float)mu, (float)mv, mrw, mrh, this.textureWidth, this.textureHeight);
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, double mouseX, double mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
    }
}

