/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.jei;

import com.yanny.ytech.compatibility.jei.TemperatureWidget;
import com.yanny.ytech.configuration.recipe.SmeltingRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SmeltingRecipeCategory
extends AbstractRecipeCategory<SmeltingRecipe> {
    public static final RecipeType<SmeltingRecipe> RECIPE_TYPE = RecipeType.create((String)"ytech", (String)"smelting", SmeltingRecipe.class);

    public SmeltingRecipeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)Component.translatable((String)"emi.category.ytech.smelting"), guiHelper.createDrawableItemLike((ItemLike)YTechItems.PRIMITIVE_SMELTER.get()), 94, 41);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmeltingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).setStandardSlotBackground().addItemStacks(Arrays.stream(recipe.ingredient().getItems()).map(i -> i.copyWithCount(recipe.inputCount())).toList());
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 24).setStandardSlotBackground().addIngredients(recipe.mold());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 72, 5).setOutputSlotBackground().addItemStack(recipe.result());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, SmeltingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addAnimatedRecipeArrow(recipe.smeltingTime()).setPosition(36, 5);
        builder.addWidget((IRecipeWidget)new TemperatureWidget(0, 2, 4000));
        builder.addAnimatedRecipeFlame(1600).setPosition(10, 24);
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull SmeltingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        if (mouseX >= 36.0 && mouseX <= 78.0 && mouseY >= 5.0 && mouseY <= 22.0) {
            tooltip.add((FormattedText)Component.translatable((String)"emi.smelting.time", (Object[])new Object[]{Float.valueOf((float)recipe.smeltingTime() / 20.0f)}));
        }
        if (mouseX >= 0.0 && mouseX <= 8.0 && mouseY >= 2.0 && mouseY <= 40.0) {
            tooltip.add((FormattedText)Component.translatable((String)"emi.smelting.temperature", (Object[])new Object[]{recipe.minTemperature()}));
        }
    }

    public static List<SmeltingRecipe> getRecipes(@NotNull RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)YTechRecipeTypes.SMELTING.get()).stream().map(RecipeHolder::value).toList();
    }

    public static void registerCatalyst(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)YTechBlocks.PRIMITIVE_SMELTER.get()), new RecipeType[]{RECIPE_TYPE, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)YTechBlocks.BRICK_CHIMNEY.get()), new RecipeType[]{RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get()), new RecipeType[]{RECIPE_TYPE});
    }
}

