/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public enum YtechAdvancementType {
    STONE_AGE(new Builder("stone_age", "root").root((ItemLike)Items.FLINT, Utils.modLoc("textures/advancements/stone_age.png"), "Stone Age", "Lasted for roughly 3.4 million years and ended with the advent of metalworking.").hasOneOfItems(new ItemLike[]{Items.FLINT})),
    FIRST_STEPS(new Builder("stone_age", "first_steps").parent(() -> YtechAdvancementType.STONE_AGE.advancement).display((ItemLike)YTechItems.SHARP_FLINT.get(), AdvancementType.TASK, "First Steps", "Hit the flint against the stone.").hasOneOfTags(YTechItemTags.SHARP_FLINTS)),
    GRASS_HUNT(new Builder("stone_age", "grass_hunt").parent(() -> YtechAdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechItems.GRASS_FIBERS.get(), AdvancementType.TASK, "Grass Hunt", "Collect grass fibers by breaking grass with a sharp flint.").hasOneOfTags(YTechItemTags.GRASS_FIBERS)),
    RUN_FOREST_RUN(new Builder("stone_age", "run_forest_run").parent(() -> YtechAdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechItems.ANTLER.get(), AdvancementType.TASK, "Run Forest Run", "Go and hunt deer for antlers.").hasOneOfTags(YTechItemTags.ANTLERS)),
    LEATHERCRAFT(new Builder("stone_age", "leathercraft").parent(() -> YtechAdvancementType.FIRST_STEPS.advancement).display((ItemLike)Items.LEATHER, AdvancementType.TASK, "Leathercraft", "Process raw hide to create leather.").hasOneOfItems(new ItemLike[]{Items.LEATHER})),
    SUNNY_DAY(new Builder("stone_age", "sunny_day").parent(() -> YtechAdvancementType.FIRST_STEPS.advancement).display((ItemLike)((DeferredItem)YTechItems.DRYING_RACKS.get(MaterialType.OAK_WOOD)).get(), AdvancementType.CHALLENGE, "Sunny Day", "Create all dried foods.").hasAllTags(YTechItemTags.DRIED_BEEFS, YTechItemTags.DRIED_CHICKENS, YTechItemTags.DRIED_CODS, YTechItemTags.DRIED_MUTTONS, YTechItemTags.DRIED_PORKCHOP, YTechItemTags.DRIED_RABBITS, YTechItemTags.DRIED_SALMONS, YTechItemTags.DRIED_VENISON)),
    SMELTER_TIME(new Builder("stone_age", "smelter_time").parent(() -> YtechAdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechBlocks.PRIMITIVE_SMELTER.get(), AdvancementType.TASK, "Smelter Time", "Craft smelter and some chimneys to be able melt crushed ore.").hasOneOfTags(YTechItemTags.PRIMITIVE_SMELTERS)),
    IRRIGATION_SYSTEM(new Builder("stone_age", "irrigation_system").parent(() -> YtechAdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechBlocks.AQUEDUCTS.of(MaterialType.TERRACOTTA).get(), AdvancementType.TASK, "Irrigation System", "Craft aqueduct for long distance water transportation.").hasOneOfTags(YTechItemTags.AQUEDUCTS.tag)),
    BETTER_THAN_NOTHING(new Builder("stone_age", "better_than_nothing").parent(() -> YtechAdvancementType.GRASS_HUNT.advancement).display((ItemLike)((DeferredItem)YTechItems.KNIVES.get(MaterialType.FLINT)).get(), AdvancementType.TASK, "Better Than Nothing", "Craft flint knife.").hasOneOfTags((TagKey)YTechItemTags.KNIVES.get(MaterialType.FLINT))),
    NOT_THAT_SIMPLE(new Builder("stone_age", "not_that_simple").parent(() -> YtechAdvancementType.GRASS_HUNT.advancement).display((ItemLike)((DeferredItem)YTechItems.AXES.get(MaterialType.FLINT)).get(), AdvancementType.TASK, "Not That Simple", "Craft flint axe to get wood.").hasOneOfTags((TagKey)YTechItemTags.AXES.get(MaterialType.FLINT))),
    MINECRAFT(new Builder("stone_age", "minecraft").parent(() -> YtechAdvancementType.GRASS_HUNT.advancement).display((ItemLike)((DeferredItem)YTechItems.PICKAXES.get(MaterialType.ANTLER)).get(), AdvancementType.TASK, "Minecraft", "First pickaxe was made from antler.").hasOneOfTags((TagKey)YTechItemTags.PICKAXES.get(MaterialType.ANTLER))),
    DIRTY_THINGS(new Builder("stone_age", "dirty_things").parent(() -> YtechAdvancementType.GRASS_HUNT.advancement).display((ItemLike)Items.WOODEN_SHOVEL, AdvancementType.TASK, "Dirty Things", "Craft wooden shovel, so you can finally build an shack.").hasOneOfItems(new ItemLike[]{Items.WOODEN_SHOVEL})),
    STORAGE_MANAGEMENT(new Builder("stone_age", "storage_management").parent(() -> YtechAdvancementType.GRASS_HUNT.advancement).display((ItemLike)YTechItems.BASKET.get(), AdvancementType.TASK, "Storage Management", "Increase your inventory capacity by crafting basket.").hasOneOfTags(YTechItemTags.BASKETS)),
    COVER_ME_IN_LEATHER(new Builder("stone_age", "cover_me_in_leather").parent(() -> YtechAdvancementType.LEATHERCRAFT.advancement).display((ItemLike)Items.LEATHER_CHESTPLATE, AdvancementType.GOAL, "Cover Me in Leather", "Craft all parts of leather armor.").hasAllItems(new ItemLike[]{Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS})),
    COPPER(new Builder("stone_age", "copper").parent(() -> YtechAdvancementType.SMELTER_TIME.advancement).display((ItemLike)Items.COPPER_INGOT, AdvancementType.TASK, "Copper", "Smelt copper ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.COPPER))),
    TIN(new Builder("stone_age", "tin").parent(() -> YtechAdvancementType.SMELTER_TIME.advancement).display((ItemLike)((DeferredItem)YTechItems.INGOTS.get(MaterialType.TIN)).get(), AdvancementType.TASK, "Tin", "Smelt tin ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.TIN))),
    TAKE_THE_LEAD(new Builder("stone_age", "take_the_lead").parent(() -> YtechAdvancementType.SMELTER_TIME.advancement).display((ItemLike)((DeferredItem)YTechItems.INGOTS.get(MaterialType.LEAD)).get(), AdvancementType.TASK, "Take The Lead", "Smelt lead ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.LEAD))),
    IN_GOLD_WE_TRUST(new Builder("stone_age", "in_gold_we_trust").parent(() -> YtechAdvancementType.SMELTER_TIME.advancement).display((ItemLike)Items.GOLD_INGOT, AdvancementType.TASK, "In Gold We Trust", "Smelt gold ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.GOLD))),
    ALLOY_SMELTER(new Builder("stone_age", "alloy_smelter").parent(() -> YtechAdvancementType.COPPER.advancement).display((ItemLike)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get(), AdvancementType.TASK, "Alloy Smelter", "Craft the alloy smelter and raise the temperature.").hasOneOfTags(YTechItemTags.PRIMITIVE_ALLOY_SMELTERS)),
    COPPER_ARMOR(new Builder("stone_age", "copper_armor").parent(() -> YtechAdvancementType.COPPER.advancement).display((ItemLike)((DeferredItem)YTechItems.CHESTPLATES.get(MaterialType.COPPER)).get(), AdvancementType.GOAL, "Copper Armor", "Craft all pieces of copper armor.").hasAllTags((TagKey)YTechItemTags.HELMETS.get(MaterialType.COPPER), (TagKey)YTechItemTags.CHESTPLATES.get(MaterialType.COPPER), (TagKey)YTechItemTags.LEGGINGS.get(MaterialType.COPPER), (TagKey)YTechItemTags.BOOTS.get(MaterialType.COPPER))),
    NEW_FRONTIER(new Builder("stone_age", "new_frontier").parent(() -> YtechAdvancementType.ALLOY_SMELTER.advancement).display((ItemLike)((DeferredItem)YTechItems.INGOTS.get(MaterialType.BRONZE)).get(), AdvancementType.GOAL, "New Frontier", "Smelting copper and tin together creates new stronger material.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.BRONZE))),
    BRONZE_AGE(new Builder("bronze_age", "root").root((ItemLike)((DeferredItem)YTechItems.AXES.get(MaterialType.BRONZE)).get(), Utils.modLoc("textures/advancements/bronze_age.png"), "Bronze Age", "Bronze Age is characterized by the use of bronze").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.BRONZE))),
    HIT_HARD(new Builder("bronze_age", "hit_hard").parent(() -> YtechAdvancementType.BRONZE_AGE.advancement).display((ItemLike)YTechBlocks.BRONZE_ANVIL.get(), AdvancementType.TASK, "Hit Hard", "Craft bronze anvil.").hasOneOfTags(YTechItemTags.BRONZE_ANVILS)),
    FERTILIZING_CROPS(new Builder("bronze_age", "fertilizing_crops").parent(() -> YtechAdvancementType.HIT_HARD.advancement).display((ItemLike)YTechBlocks.AQUEDUCT_FERTILIZER.get(), AdvancementType.TASK, "Fertilizing Crops", "Craft aqueduct fertilizer.").hasOneOfTags(YTechItemTags.AQUEDUCT_FERTILIZERS)),
    BRONZE_ARMOR(new Builder("stone_age", "bronze_armor").parent(() -> YtechAdvancementType.BRONZE_AGE.advancement).display((ItemLike)((DeferredItem)YTechItems.CHESTPLATES.get(MaterialType.BRONZE)).get(), AdvancementType.GOAL, "Bronze Armor", "Craft all pieces of bronze armor.").hasAllTags((TagKey)YTechItemTags.HELMETS.get(MaterialType.BRONZE), (TagKey)YTechItemTags.CHESTPLATES.get(MaterialType.BRONZE), (TagKey)YTechItemTags.LEGGINGS.get(MaterialType.BRONZE), (TagKey)YTechItemTags.BOOTS.get(MaterialType.BRONZE))),
    BRONZE_TOOLS(new Builder("bronze_age", "bronze_tools").parent(() -> YtechAdvancementType.BRONZE_AGE.advancement).display((ItemLike)((DeferredItem)YTechItems.PICKAXES.get(MaterialType.BRONZE)).get(), AdvancementType.GOAL, "Bronze Tools", "Craft all bronze tools.").hasAllTags((TagKey)YTechItemTags.PICKAXES.get(MaterialType.BRONZE), (TagKey)YTechItemTags.AXES.get(MaterialType.BRONZE), (TagKey)YTechItemTags.SHOVELS.get(MaterialType.BRONZE), (TagKey)YTechItemTags.SWORDS.get(MaterialType.BRONZE))),
    MORE_AND_MORE(new Builder("bronze_age", "more_and_more").parent(() -> YtechAdvancementType.BRONZE_AGE.advancement).display((ItemLike)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get(), AdvancementType.TASK, "More and More", "Craft reinforced brick chimney.").hasOneOfTags(YTechItemTags.REINFORCED_BRICK_CHIMNEYS)),
    BLOOMBERG(new Builder("bronze_age", "bloomberg").parent(() -> YtechAdvancementType.MORE_AND_MORE.advancement).display((ItemLike)YTechItems.IRON_BLOOM.get(), AdvancementType.TASK, "Bloomberg", "Smelt iron with charcoal to create iron bloom.").hasOneOfTags(YTechItemTags.IRON_BLOOMS)),
    IRON_MAN(new Builder("bronze_age", "iron_man").parent(() -> YtechAdvancementType.BLOOMBERG.advancement).display((ItemLike)Items.IRON_INGOT, AdvancementType.TASK, "Iron Man", "Using hammer on iron bloom creates iron ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)));

    private static final String STONE_AGE_GROUP = "stone_age";
    private static final String BRONZE_AGE_GROUP = "bronze_age";
    private final Builder builder;
    private AdvancementHolder advancement;

    private YtechAdvancementType(Builder builder) {
        this.builder = builder;
    }

    public String titleId() {
        return this.builder.titleId;
    }

    public String title() {
        return this.builder.title;
    }

    public String description() {
        return this.builder.description;
    }

    public String descriptionId() {
        return this.builder.descriptionId;
    }

    public void generate(@NotNull Consumer<AdvancementHolder> saver, @NotNull ExistingFileHelper existingFileHelper) {
        if (this.builder.advancement != null) {
            this.builder.builder.parent(this.builder.advancement.get());
        }
        this.advancement = this.builder.builder.save(saver, Utils.modLoc(this.builder.group + "/" + this.builder.id), existingFileHelper);
    }

    private static class Builder {
        private final Advancement.Builder builder;
        private final String group;
        private final String id;
        private Supplier<AdvancementHolder> advancement;
        private String titleId = "";
        private String title = "";
        private String descriptionId = "";
        private String description = "";

        Builder(@NotNull String group, @NotNull String id) {
            this.group = group;
            this.id = id;
            this.builder = Advancement.Builder.advancement();
        }

        Builder parent(@NotNull Supplier<AdvancementHolder> advancement) {
            this.advancement = advancement;
            return this;
        }

        Builder root(@NotNull ItemLike icon, @NotNull ResourceLocation background, @NotNull String title, @NotNull String descr) {
            this.title = title;
            this.description = descr;
            this.titleId = "advancements.ytech." + this.group + ".title." + this.id;
            this.descriptionId = "advancements.ytech." + this.group + ".description." + this.id;
            this.builder.display(icon, (Component)Component.translatable((String)this.titleId), (Component)Component.translatable((String)this.descriptionId), background, AdvancementType.TASK, false, false, false);
            return this;
        }

        Builder display(@NotNull ItemLike icon, @NotNull AdvancementType type, @NotNull String title, @NotNull String descr) {
            this.title = title;
            this.description = descr;
            this.titleId = "advancements.ytech." + this.group + ".title." + this.id;
            this.descriptionId = "advancements.ytech." + this.group + ".description." + this.id;
            this.builder.display(icon, (Component)Component.translatable((String)this.titleId), (Component)Component.translatable((String)this.descriptionId), null, type, false, false, false);
            return this;
        }

        Builder hasOneOfItems(ItemLike ... items) {
            this.builder.addCriterion(Utils.getHasName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(items).build()}));
            return this;
        }

        Builder hasAllItems(ItemLike ... items) {
            this.builder.requirements(AdvancementRequirements.Strategy.AND);
            for (ItemLike item : items) {
                this.builder.addCriterion(RecipeProvider.getHasName((ItemLike)item), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()}));
            }
            return this;
        }

        @SafeVarargs
        final Builder hasOneOfTags(TagKey<Item> ... tags) {
            this.builder.requirements(AdvancementRequirements.Strategy.OR);
            for (TagKey<Item> tag : tags) {
                this.builder.addCriterion(Utils.getHasName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()}));
            }
            return this;
        }

        @SafeVarargs
        final Builder hasAllTags(TagKey<Item> ... tags) {
            this.builder.requirements(AdvancementRequirements.Strategy.AND);
            for (TagKey<Item> tag : tags) {
                this.builder.addCriterion(Utils.getHasName() + "_" + tag.location().getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()}));
            }
            return this;
        }
    }
}

