/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.AqueductBlockEntity;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.network.irrigation.IrrigationClientNetwork;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductBlock
extends IrrigationBlock
implements BucketPickup,
LiquidBlockContainer {
    private static final VoxelShape SHAPE_BOTTOM = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private static final VoxelShape SHAPE_NORTH_SIDE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125);
    private static final VoxelShape SHAPE_EAST_SIDE = Shapes.box((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_SOUTH_SIDE = Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_WEST_SIDE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_NORTH_WEST_SIDE = Shapes.join((VoxelShape)SHAPE_WEST_SIDE, (VoxelShape)SHAPE_NORTH_SIDE, (BooleanOp)BooleanOp.AND);
    private static final VoxelShape SHAPE_NORTH_EAST_SIDE = Shapes.join((VoxelShape)SHAPE_NORTH_SIDE, (VoxelShape)SHAPE_EAST_SIDE, (BooleanOp)BooleanOp.AND);
    private static final VoxelShape SHAPE_SOUTH_EAST_SIDE = Shapes.join((VoxelShape)SHAPE_EAST_SIDE, (VoxelShape)SHAPE_SOUTH_SIDE, (BooleanOp)BooleanOp.AND);
    private static final VoxelShape SHAPE_SOUTH_WEST_SIDE = Shapes.join((VoxelShape)SHAPE_SOUTH_SIDE, (VoxelShape)SHAPE_WEST_SIDE, (BooleanOp)BooleanOp.AND);
    private static final BooleanProperty NORTH_EAST = BooleanProperty.create((String)"north_east");
    private static final BooleanProperty NORTH_WEST = BooleanProperty.create((String)"north_west");
    private static final BooleanProperty SOUTH_EAST = BooleanProperty.create((String)"south_east");
    private static final BooleanProperty SOUTH_WEST = BooleanProperty.create((String)"south_west");
    private final Map<BlockState, VoxelShape> shapesCache = this.getShapeForEachState(AqueductBlock::calculateShape);
    private final MaterialType material;

    public AqueductBlock(MaterialType material) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TERRACOTTA));
        this.material = material;
    }

    public int getCapacity() {
        return switch (this.material) {
            case MaterialType.MUDBRICK -> YTechMod.CONFIGURATION.getBaseFluidStoragePerBlock();
            case MaterialType.TERRACOTTA -> YTechMod.CONFIGURATION.getBaseFluidStoragePerBlock() * 2;
            case MaterialType.STONE -> YTechMod.CONFIGURATION.getBaseFluidStoragePerBlock() * 4;
            default -> throw new IllegalStateException(String.format("Missing material type %s", this.material));
        };
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shapesCache.get(state);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BlockStateProperties.EAST}).add(new Property[]{BlockStateProperties.WEST}).add(new Property[]{BlockStateProperties.SOUTH}).add(new Property[]{BlockStateProperties.NORTH}).add(new Property[]{NORTH_EAST}).add(new Property[]{NORTH_WEST}).add(new Property[]{SOUTH_EAST}).add(new Property[]{SOUTH_WEST});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        BlockState state = this.defaultBlockState();
        Level level = blockPlaceContext.getLevel();
        BlockPos pos = blockPlaceContext.getClickedPos();
        boolean hasNorthConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductBlock.isValidForConnection((LevelAccessor)level, pos, Direction.WEST);
        state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(!hasNorthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(!hasEastConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(!hasSouthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(!hasWestConnection));
        state = (BlockState)state.setValue((Property)NORTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.west(), BlockStateProperties.NORTH) || AqueductBlock.hasSide((LevelAccessor)level, pos.north(), BlockStateProperties.WEST) || !hasWestConnection || !hasNorthConnection));
        state = (BlockState)state.setValue((Property)NORTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.north(), BlockStateProperties.EAST) || AqueductBlock.hasSide((LevelAccessor)level, pos.east(), BlockStateProperties.NORTH) || !hasNorthConnection || !hasEastConnection));
        state = (BlockState)state.setValue((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.east(), BlockStateProperties.SOUTH) || AqueductBlock.hasSide((LevelAccessor)level, pos.south(), BlockStateProperties.EAST) || !hasEastConnection || !hasSouthConnection));
        state = (BlockState)state.setValue((Property)SOUTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide((LevelAccessor)level, pos.south(), BlockStateProperties.WEST) || AqueductBlock.hasSide((LevelAccessor)level, pos.west(), BlockStateProperties.SOUTH) || !hasSouthConnection || !hasWestConnection));
        return state;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        boolean hasNorthConnection = AqueductBlock.isValidForConnection(level, pos, Direction.NORTH);
        boolean hasEastConnection = AqueductBlock.isValidForConnection(level, pos, Direction.EAST);
        boolean hasSouthConnection = AqueductBlock.isValidForConnection(level, pos, Direction.SOUTH);
        boolean hasWestConnection = AqueductBlock.isValidForConnection(level, pos, Direction.WEST);
        state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(!hasNorthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(!hasEastConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(!hasSouthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(!hasWestConnection));
        state = (BlockState)state.setValue((Property)NORTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.west(), BlockStateProperties.NORTH) || AqueductBlock.hasSide(level, pos.north(), BlockStateProperties.WEST) || !hasWestConnection || !hasNorthConnection));
        state = (BlockState)state.setValue((Property)NORTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.north(), BlockStateProperties.EAST) || AqueductBlock.hasSide(level, pos.east(), BlockStateProperties.NORTH) || !hasNorthConnection || !hasEastConnection));
        state = (BlockState)state.setValue((Property)SOUTH_EAST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.east(), BlockStateProperties.SOUTH) || AqueductBlock.hasSide(level, pos.south(), BlockStateProperties.EAST) || !hasEastConnection || !hasSouthConnection));
        state = (BlockState)state.setValue((Property)SOUTH_WEST, (Comparable)Boolean.valueOf(AqueductBlock.hasSide(level, pos.south(), BlockStateProperties.WEST) || AqueductBlock.hasSide(level, pos.west(), BlockStateProperties.SOUTH) || !hasSouthConnection || !hasWestConnection));
        return state;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        return new AqueductBlockEntity(pos, blockState, this.getCapacity());
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = level.getBlockEntity(pos)) instanceof AqueductBlockEntity) {
            FluidTank tank;
            AqueductBlockEntity aqueductBlock = (AqueductBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(aqueductBlock);
            if (network != null && (tank = network.getFluidHandler()).getFluidAmount() >= 1000) {
                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                return new ItemStack((ItemLike)Items.WATER_BUCKET);
            }
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }

    public boolean canPlaceLiquid(@Nullable Player player, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluid) {
        return fluid == Fluids.WATER;
    }

    public boolean placeLiquid(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        BlockEntity blockEntity;
        if (fluidState.getType() == Fluids.WATER && !level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof AqueductBlockEntity) {
            AqueductBlockEntity aqueductBlock = (AqueductBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(aqueductBlock);
            if (network != null) {
                FluidTank tank = network.getFluidHandler();
                tank.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        BlockEntity blockEntity;
        if ((!(entity instanceof LivingEntity) || entity.getInBlockState().is((Block)this)) && (blockEntity = level.getBlockEntity(pos)) instanceof AqueductBlockEntity) {
            AqueductBlockEntity aqueductBlockEntity = (AqueductBlockEntity)blockEntity;
            double multiplier = 0.5;
            if (level.isClientSide) {
                IrrigationClientNetwork network = YTechMod.IRRIGATION_PROPAGATOR.client().getNetwork(aqueductBlockEntity);
                if (network != null && network.getCapacity() > 0) {
                    multiplier = Mth.clamp((double)((1.0 - (double)network.getAmount() / (double)network.getCapacity()) * 0.5), (double)0.0, (double)0.5);
                    if (entity.isOnFire()) {
                        entity.extinguishFire();
                    }
                }
            } else {
                IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(aqueductBlockEntity);
                if (network != null && network.getFluidHandler().getCapacity() > 0) {
                    multiplier = Mth.clamp((double)((1.0 - (double)network.getFluidHandler().getFluidAmount() / (double)network.getFluidHandler().getCapacity()) * 0.5), (double)0.0, (double)0.5);
                    if (entity.isOnFire()) {
                        entity.extinguishFire();
                    }
                }
            }
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(new Vec3(0.5 + multiplier, 1.0, 0.5 + multiplier)));
        }
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return true;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AqueductBlockEntity) {
            AqueductBlockEntity blockEntity2 = (AqueductBlockEntity)blockEntity;
            blockEntity2.onRandomTick();
        }
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return Direction.Plane.HORIZONTAL.stream().map(dir -> pos.offset(dir.getNormal())).toList();
    }

    public static void registerModel(@NotNull BlockStateProvider provider, @NotNull DeferredBlock<Block> block, MaterialType material) {
        ResourceLocation bricks = switch (material) {
            case MaterialType.MUDBRICK -> Utils.mcBlockLoc("mud_bricks");
            case MaterialType.TERRACOTTA -> Utils.modBlockLoc("terracotta_bricks");
            case MaterialType.STONE -> Utils.mcBlockLoc("stone_bricks");
            default -> throw new IllegalStateException();
        };
        String name = Utils.getPath(block);
        ModelBuilder base = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name)).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 14.0f, 16.0f, 16.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 2.0f, 16.0f).end()).texture("particle", bricks)).texture("0", bricks);
        ModelBuilder side = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_side")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 14.0f).texture("#0");
                    break;
                }
                case NORTH: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 14.0f).texture("#0").cullface(direction);
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 2.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).texture("#0").cullface(direction);
                }
            }
        }).from(2.0f, 2.0f, 0.0f).to(14.0f, 16.0f, 2.0f).end()).texture("particle", bricks)).texture("0", bricks);
        ModelBuilder edge = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_edge")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0").cullface(direction);
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#0").cullface(direction);
                }
            }
        }).from(0.0f, 2.0f, 0.0f).to(2.0f, 16.0f, 2.0f).end()).texture("particle", bricks)).texture("0", bricks);
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)provider.getMultipartBuilder((Block)block.get()).part().modelFile((ModelFile)base).addModel()).end();
        PROPERTY_BY_DIRECTION.forEach((arg_0, arg_1) -> AqueductBlock.lambda$registerModel$4(builder, (ModelFile)side, arg_0, arg_1));
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.NORTH)).intValue()).addModel()).condition((Property)NORTH_WEST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.EAST)).intValue()).addModel()).condition((Property)NORTH_EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.SOUTH)).intValue()).addModel()).condition((Property)SOUTH_EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)edge).rotationY(((Integer)ANGLE_BY_DIRECTION.get(Direction.WEST)).intValue()).addModel()).condition((Property)SOUTH_WEST, (Comparable[])new Boolean[]{true}).end();
        ModelBuilder itemModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_inventory")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 14.0f, 16.0f, 16.0f).texture("#0");
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#0");
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 2.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 2.0f).texture("#0");
                }
            }
        }).from(0.0f, 2.0f, 0.0f).to(16.0f, 16.0f, 2.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 14.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 2.0f).texture("#0");
                }
            }
        }).from(0.0f, 2.0f, 14.0f).to(16.0f, 16.0f, 16.0f).end()).texture("particle", bricks)).texture("0", bricks);
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)itemModel);
    }

    public static void registerRecipe(RecipeOutput recipeConsumer, DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case MUDBRICK: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get(), 2).define(Character.valueOf('#'), (ItemLike)Items.MUD_BRICKS).pattern("# #").pattern("# #").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has((ItemLike)Items.MUD_BRICKS)).save(recipeConsumer, Utils.modLoc(item));
                break;
            }
            case TERRACOTTA: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get(), 2).define(Character.valueOf('#'), YTechItemTags.TERRACOTTA_BRICKS).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("# #").pattern("#H#").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.TERRACOTTA_BRICKS)).save(recipeConsumer, Utils.modLoc(item));
                break;
            }
            case STONE: {
                RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)item.get(), 2).define(Character.valueOf('#'), (ItemLike)Items.STONE_BRICKS).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("# #").pattern("#H#").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has((ItemLike)Items.STONE_BRICKS)).save(recipeConsumer, Utils.modLoc(item));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean hasSide(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BooleanProperty property) {
        BlockState blockState = level.getBlockState(pos);
        boolean isIrrigation = blockState.getBlock() instanceof AqueductBlock;
        return isIrrigation && blockState.hasProperty((Property)property) && (Boolean)blockState.getValue((Property)property) != false;
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape shape = SHAPE_BOTTOM;
        if (((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_NORTH_SIDE, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_EAST_SIDE, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH_SIDE, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_WEST_SIDE, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)NORTH_WEST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_NORTH_WEST_SIDE, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)NORTH_EAST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_NORTH_EAST_SIDE, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)SOUTH_EAST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH_EAST_SIDE, (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)SOUTH_WEST)).booleanValue()) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH_WEST_SIDE, (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    private static /* synthetic */ void lambda$registerModel$4(MultiPartBlockStateBuilder builder, ModelFile side, Direction dir, BooleanProperty value) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((Integer)ANGLE_BY_DIRECTION.get(dir)).intValue()).addModel()).condition((Property)value, (Comparable[])new Boolean[]{true}).end();
    }
}

