/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.mojang.serialization.MapCodec;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.BronzeAnvilBlockEntity;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BronzeAnvilBlock
extends FallingBlock
implements EntityBlock {
    private static final VoxelShape BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape X_LEG1 = Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape X_LEG2 = Block.box((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape X_TOP = Block.box((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape Z_LEG1 = Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape Z_LEG2 = Block.box((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape Z_TOP = Block.box((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{X_LEG1, X_LEG2, X_TOP});
    private static final VoxelShape Z_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Z_LEG1, Z_LEG2, Z_TOP});

    public BronzeAnvilBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANVIL));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BronzeAnvilBlockEntity(pos, state);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.BRONZE_ANVIL.get());
        if (optional.isPresent()) {
            return ((BronzeAnvilBlockEntity)((Object)optional.get())).onUse(state, level, pos, player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof BronzeAnvilBlockEntity) {
            BronzeAnvilBlockEntity anvil = (BronzeAnvilBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)NonNullList.withSize((int)1, (Object)anvil.getItem()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getClockWise());
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return direction.getAxis() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    protected void falling(FallingBlockEntity blockEntity) {
        blockEntity.setHurtsEntities(2.0f, 40);
    }

    public void onLand(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockState replaceableState, @NotNull FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent()) {
            level.levelEvent(1031, pos, 0);
        }
    }

    public void onBrokenAfterFall(@NotNull Level level, @NotNull BlockPos pos, @NotNull FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent()) {
            level.levelEvent(1029, pos, 0);
        }
    }

    @NotNull
    public DamageSource getFallDamageSource(@NotNull Entity entity) {
        return entity.damageSources().anvil(entity);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends BronzeAnvilBlock> codec() {
        throw new RuntimeException("Not implemented yet!");
    }

    public int getDustColor(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.getMapColor((BlockGetter)level, (BlockPos)pos).col;
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.BRONZE_ANVIL))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(2.0f, 12.0f, 14.0f, 16.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 12.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(2.0f, 0.0f, 14.0f, 12.0f).texture("#1").cullface(direction);
                }
            }
        }).from(2.0f, 0.0f, 2.0f).to(14.0f, 4.0f, 14.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(4.0f, 3.0f, 12.0f, 4.0f).texture("#1");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(4.0f, 4.0f, 12.0f, 5.0f).texture("#1");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 1.0f, 12.0f, 2.0f).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(4.0f, 2.0f, 12.0f, 3.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 3.0f, 12.0f, 13.0f).texture("#1");
                }
            }
        }).from(4.0f, 4.0f, 3.0f).to(12.0f, 5.0f, 13.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(6.0f, 6.0f, 10.0f, 11.0f).texture("#1");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(4.0f, 6.0f, 12.0f, 11.0f).texture("#1");
                }
            }
        }).from(6.0f, 5.0f, 4.0f).to(10.0f, 10.0f, 12.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(10.0f, 0.0f, 16.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1").cullface(direction);
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 10.0f, 16.0f, 16.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(3.0f, 0.0f, 13.0f, 16.0f).texture("#2").cullface(direction);
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 1.0f, 16.0f, 11.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1");
                }
            }
        }).from(3.0f, 10.0f, 0.0f).to(13.0f, 16.0f, 16.0f).end()).texture("particle", Utils.modBlockLoc("bronze_anvil"))).texture("1", Utils.modBlockLoc("bronze_anvil"))).texture("2", Utils.modBlockLoc("bronze_anvil_top"));
        provider.horizontalBlock((Block)YTechBlocks.BRONZE_ANVIL.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.BRONZE_ANVIL))).parent((ModelFile)model);
    }

    public static void registerRecipe(@NotNull RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)YTechBlocks.BRONZE_ANVIL.get()).define(Character.valueOf('B'), (TagKey<Item>)((TagKey)YTechItemTags.STORAGE_BLOCKS.get(MaterialType.BRONZE))).bottomPattern(" B ").bottomPattern("BBB").bottomPattern(" B ").middlePattern("   ").middlePattern(" B ").middlePattern("   ").topPattern("BBB").topPattern("BBB").topPattern("BBB").unlockedBy(Utils.getHasName(), RecipeProvider.has((TagKey)((TagKey)YTechItemTags.INGOTS.get(MaterialType.BRONZE)))).save(recipeConsumer, Utils.modLoc(YTechBlocks.BRONZE_ANVIL));
    }
}

