/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.FirePitBlockEntity;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirePitBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_DOWN = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private static final VoxelShape SHAPE_UP = Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625);
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)SHAPE_DOWN, (VoxelShape)SHAPE_UP, (BooleanOp)BooleanOp.OR);

    public FirePitBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.WOOD).noOcclusion().hasPostProcess(FirePitBlock::always).lightLevel(FirePitBlock::getLightLevel));
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean propagatesSkylightDown(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return true;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BlockStateProperties.LIT}).add(new Property[]{BlockStateProperties.LEVEL});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new FirePitBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide) {
            return FirePitBlock::createFirePitTicker;
        }
        return null;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof FirePitBlockEntity) {
            FirePitBlockEntity firePit = (FirePitBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)NonNullList.withSize((int)1, (Object)firePit.getItem()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void animateTick(@NotNull BlockState pState, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)pState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            if (level.isRainingAt(pos.above())) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.25 + (double)(random.nextFloat() / 2.0f), (double)pos.getY() + 0.3, (double)pos.getZ() + 0.25 + (double)(random.nextFloat() / 2.0f), 0.0, 0.0, 0.0);
            }
            if ((Integer)pState.getValue((Property)BlockStateProperties.LEVEL) > 0) {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.25 + (double)(random.nextFloat() / 2.0f), (double)pos.getY() + 0.2, (double)pos.getZ() + 0.25 + (double)(random.nextFloat() / 2.0f), 0.0, 0.0, 0.0);
                if (random.nextInt(16 - (Integer)pState.getValue((Property)BlockStateProperties.LEVEL)) == 0) {
                    level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, false, (double)pos.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + random.nextDouble() + random.nextDouble(), (double)pos.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
                }
                if (random.nextInt(10) == 0) {
                    level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
                }
                if (random.nextInt(5) == 0) {
                    for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                        level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
                    }
                }
            }
        }
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LIT);
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if ((Integer)state.getValue((Property)BlockStateProperties.LEVEL) > 0) {
            if (random.nextDouble() > 0.5 && ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && level.isRainingAt(pos.above())) {
                level.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 0.8f + random.nextFloat() * 0.4f);
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.25 + (double)(random.nextFloat() / 2.0f), (double)pos.getY() + 0.3, (double)pos.getZ() + 0.25 + (double)(random.nextFloat() / 2.0f), 0.0, 0.0, 0.0);
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)BlockStateProperties.LEVEL) - 1)), 3);
            }
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && player.getItemInHand(InteractionHand.MAIN_HAND).is(Items.STICK) && player.getItemInHand(InteractionHand.OFF_HAND).is(Items.STICK)) {
            player.getItemInHand(InteractionHand.MAIN_HAND).shrink(1);
            player.getItemInHand(InteractionHand.OFF_HAND).shrink(1);
            if (level instanceof ServerLevel) {
                if (player.getRandom().nextFloat() < 0.4f) {
                    level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 0.8f + player.getRandom().nextFloat() * 0.4f);
                    level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
                } else {
                    level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 0.8f + player.getRandom().nextFloat() * 0.4f);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        ItemStack itemStack = player.getItemInHand(hand);
        int burnTime = itemStack.getBurnTime(null);
        if (burnTime > 0 && (Integer)state.getValue((Property)BlockStateProperties.LEVEL) < 15) {
            itemStack.shrink(1);
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(Math.min(15, (Integer)state.getValue((Property)BlockStateProperties.LEVEL) + (int)Math.log10(burnTime)))), 3);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FirePitBlockEntity) {
            FirePitBlockEntity blockEntity2 = (FirePitBlockEntity)blockEntity;
            return blockEntity2.onUse(state, level, pos, player, hand, hit);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false));
    }

    public void entityInside(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().campfire(), (float)((Integer)state.getValue((Property)BlockStateProperties.LEVEL)).intValue() / 15.0f);
        }
        super.entityInside(state, level, pos, entity);
    }

    public void onProjectileHit(@NotNull Level level, @NotNull BlockState state, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        BlockPos pos = hit.getBlockPos();
        if (!level.isClientSide && projectile.isOnFire() && projectile.mayInteract(level, pos) && !((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean isPathfindable(@NotNull BlockState pState, @NotNull PathComputationType pType) {
        return false;
    }

    public static void registerModel(BlockStateProvider provider) {
        ResourceLocation magmaTexture = Utils.mcBlockLoc("magma");
        ResourceLocation andesiteTexture = Utils.mcBlockLoc("andesite");
        ResourceLocation logTexture = Utils.mcBlockLoc("oak_log");
        ResourceLocation logTopTexture = Utils.mcBlockLoc("oak_log_top");
        ResourceLocation basaltTexture = Utils.mcBlockLoc("smooth_basalt");
        ResourceLocation ropeTexture = Utils.modBlockLoc("horizontal_rope");
        String name = Utils.getPath(YTechBlocks.FIRE_PIT);
        ModelBuilder base_lit = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_base_lit")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(3.0f, 0.0f, 5.0f, 1.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(2.0f, 1.0f, 4.0f, 2.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(11.0f, 2.0f, 13.0f, 4.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(13.0f, 8.0f, 15.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(3.47487f, 0.0f, 11.8033f).to(5.47487f, 1.0f, 13.8033f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(4.47487f, 0.5f, 12.8033f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case WEST: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(1.35355f, 0.0f, 9.68198f).to(3.35355f, 1.0f, 11.68198f).rotation().angle(22.5f).axis(Direction.Axis.Y).origin(2.35355f, 0.5f, 10.68198f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(10.0f, 6.0f, 13.0f, 8.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(13.0f, 0.0f, 7.0f).to(15.0f, 1.0f, 10.0f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(14.0f, 0.5f, 8.5f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 1.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 6.0f, 3.0f, 8.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2").cullface(direction);
                }
            }
        }).from(9.63693f, 0.0f, 10.84404f).to(12.63693f, 1.0f, 12.84404f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(11.13693f, 0.5f, 11.84404f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 1.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2").cullface(direction);
                }
            }
        }).from(6.63173f, 0.0f, 0.83883f).to(9.63173f, 1.0f, 2.83883f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.13173f, 0.5f, 1.83883f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(5.0f, 4.0f, 8.0f, 6.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(4.0f, 8.0f, 7.0f, 10.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(13.0f, 6.0f, 16.0f, 8.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(10.0f, 6.0f, 13.0f, 8.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(9.0f, 2.0f, 12.0f, 5.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(11.0f, 9.0f, 14.0f, 12.0f).texture("#2").cullface(direction);
                }
            }
        }).from(2.74264f, 0.0f, 2.03553f).to(5.74264f, 2.0f, 5.03553f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(4.24264f, 1.0f, 3.53553f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 3.0f, 2.0f, 5.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(3.0f, 9.0f, 5.0f, 11.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(11.0f, 1.0f, 13.0f, 3.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 1.0f, 6.0f, 3.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 4.0f, 9.0f, 6.0f).texture("#2").cullface(direction);
                }
            }
        }).from(12.10022f, 0.0f, 4.54521f).to(14.10022f, 2.0f, 6.54521f).rotation().angle(22.5f).axis(Direction.Axis.Y).origin(13.10022f, 1.25f, 5.54521f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 4.0f, 2.0f, 6.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 9.0f, 6.0f, 11.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 8.0f, 9.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(10.12655f, 0.0f, 2.03034f).to(12.12655f, 2.0f, 4.03034f).rotation().angle(-45.0f).axis(Direction.Axis.Y).origin(11.12655f, 1.25f, 3.03034f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(14.0f, 4.0f, 16.0f, 6.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(5.0f, 4.0f, 8.0f, 6.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 0.0f, 6.0f, 2.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(9.0f, 2.0f, 12.0f, 4.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(11.0f, 6.0f, 13.0f, 9.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 7.0f, 9.0f, 10.0f).texture("#2").cullface(direction);
                }
            }
        }).from(0.83581f, 0.0f, 6.1924f).to(2.83581f, 2.0f, 9.1924f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(1.83581f, 1.0f, 7.6924f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(3.0f, 0.0f, 6.0f, 2.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(9.0f, 0.0f, 11.0f, 2.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 2.0f, 3.0f, 4.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(5.0f, 2.0f, 7.0f, 4.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 4.0f, 7.0f, 6.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 3.0f, 10.0f, 5.0f).texture("#2").cullface(direction);
                }
            }
        }).from(6.19657f, 0.0f, 13.0391f).to(9.19657f, 2.0f, 15.0391f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(7.69657f, 1.0f, 14.0391f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 10.0f, 10.0f).texture("#0").emissivity(15, 8);
                }
            }
        }).from(3.0f, 0.01f, 3.0f).to(13.0f, 0.01f, 13.0f).rotation().angle(-45.0f).axis(Direction.Axis.Y).origin(8.0f, 0.01f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 14.0f).texture("#1");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(10.0f, 0.0f, 12.0f, 14.0f).texture("#1");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(12.0f, 0.0f, 14.0f, 14.0f).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 7.0f).to(2.0f, 14.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 14.0f).texture("#1");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(10.0f, 0.0f, 12.0f, 14.0f).texture("#1").cullface(direction);
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(12.0f, 0.0f, 14.0f, 14.0f).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3").cullface(direction);
                }
            }
        }).from(14.0f, 0.0f, 7.0f).to(16.0f, 14.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 4.0f).texture("#4");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 1.0f, 1.0f).texture("#4");
                }
            }
        }).from(2.0f, 11.5f, 8.0f).to(14.0f, 13.5f, 8.0f).end()).texture("particle", magmaTexture)).texture("0", magmaTexture)).texture("1", logTexture)).texture("2", andesiteTexture)).texture("3", logTopTexture)).texture("4", ropeTexture);
        ModelBuilder base = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_base")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(3.0f, 0.0f, 5.0f, 1.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(2.0f, 1.0f, 4.0f, 2.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(11.0f, 2.0f, 13.0f, 4.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(13.0f, 8.0f, 15.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(3.47487f, 0.0f, 11.8033f).to(5.47487f, 1.0f, 13.8033f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(4.47487f, 0.5f, 12.8033f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case WEST: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(1.35355f, 0.0f, 9.68198f).to(3.35355f, 1.0f, 11.68198f).rotation().angle(22.5f).axis(Direction.Axis.Y).origin(2.35355f, 0.5f, 10.68198f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(10.0f, 6.0f, 13.0f, 8.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(13.0f, 0.0f, 7.0f).to(15.0f, 1.0f, 10.0f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(14.0f, 0.5f, 8.5f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 1.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 6.0f, 3.0f, 8.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2").cullface(direction);
                }
            }
        }).from(9.63693f, 0.0f, 10.84404f).to(12.63693f, 1.0f, 12.84404f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(11.13693f, 0.5f, 11.84404f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 1.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 1.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2").cullface(direction);
                }
            }
        }).from(6.63173f, 0.0f, 0.83883f).to(9.63173f, 1.0f, 2.83883f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.13173f, 0.5f, 1.83883f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(5.0f, 4.0f, 8.0f, 6.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(4.0f, 8.0f, 7.0f, 10.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(13.0f, 6.0f, 16.0f, 8.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(10.0f, 6.0f, 13.0f, 8.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(9.0f, 2.0f, 12.0f, 5.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(11.0f, 9.0f, 14.0f, 12.0f).texture("#2").cullface(direction);
                }
            }
        }).from(2.74264f, 0.0f, 2.03553f).to(5.74264f, 2.0f, 5.03553f).rotation().angle(45.0f).axis(Direction.Axis.Y).origin(4.24264f, 1.0f, 3.53553f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 3.0f, 2.0f, 5.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(3.0f, 9.0f, 5.0f, 11.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(11.0f, 1.0f, 13.0f, 3.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 1.0f, 6.0f, 3.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 4.0f, 9.0f, 6.0f).texture("#2").cullface(direction);
                }
            }
        }).from(12.10022f, 0.0f, 4.54521f).to(14.10022f, 2.0f, 6.54521f).rotation().angle(22.5f).axis(Direction.Axis.Y).origin(13.10022f, 1.25f, 5.54521f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 4.0f, 2.0f, 6.0f).texture("#2");
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 9.0f, 6.0f, 11.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 8.0f, 9.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#2").cullface(direction);
                }
            }
        }).from(10.12655f, 0.0f, 2.03034f).to(12.12655f, 2.0f, 4.03034f).rotation().angle(-45.0f).axis(Direction.Axis.Y).origin(11.12655f, 1.25f, 3.03034f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(14.0f, 4.0f, 16.0f, 6.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(5.0f, 4.0f, 8.0f, 6.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 0.0f, 6.0f, 2.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(9.0f, 2.0f, 12.0f, 4.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(11.0f, 6.0f, 13.0f, 9.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 7.0f, 9.0f, 10.0f).texture("#2").cullface(direction);
                }
            }
        }).from(0.83581f, 0.0f, 6.1924f).to(2.83581f, 2.0f, 9.1924f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(1.83581f, 1.0f, 7.6924f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(3.0f, 0.0f, 6.0f, 2.0f).texture("#2");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(9.0f, 0.0f, 11.0f, 2.0f).texture("#2");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 2.0f, 3.0f, 4.0f).texture("#2");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(5.0f, 2.0f, 7.0f, 4.0f).texture("#2");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 4.0f, 7.0f, 6.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 3.0f, 10.0f, 5.0f).texture("#2").cullface(direction);
                }
            }
        }).from(6.19657f, 0.0f, 13.0391f).to(9.19657f, 2.0f, 15.0391f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(7.69657f, 1.0f, 14.0391f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 10.0f, 10.0f).texture("#0");
                }
            }
        }).from(3.0f, 0.01f, 3.0f).to(13.0f, 0.01f, 13.0f).rotation().angle(-45.0f).axis(Direction.Axis.Y).origin(8.0f, 0.01f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 14.0f).texture("#1");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(10.0f, 0.0f, 12.0f, 14.0f).texture("#1");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(12.0f, 0.0f, 14.0f, 14.0f).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 7.0f).to(2.0f, 14.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 14.0f).texture("#1");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(10.0f, 0.0f, 12.0f, 14.0f).texture("#1").cullface(direction);
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(12.0f, 0.0f, 14.0f, 14.0f).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 14.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#3").cullface(direction);
                }
            }
        }).from(14.0f, 0.0f, 7.0f).to(16.0f, 14.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 4.0f).texture("#4");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 1.0f, 1.0f).texture("#4");
                }
            }
        }).from(2.0f, 11.5f, 8.0f).to(14.0f, 13.5f, 8.0f).end()).texture("particle", basaltTexture)).texture("0", basaltTexture)).texture("1", logTexture)).texture("2", andesiteTexture)).texture("3", logTopTexture)).texture("4", ropeTexture);
        ModelBuilder logs_down = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_logs_up")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#4");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(9.0f, 4.0f, 13.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(2.0f, 0.0f, 6.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 10.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(1.0f, 3.0f, 5.0f, 13.0f).texture("#3").cullface(direction);
                }
            }
        }).from(8.25f, 0.0f, 4.25f).to(10.25f, 2.0f, 10.25f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).texture("#4");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(4.0f, 5.0f, 8.0f, 15.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 2.0f, 4.0f, 12.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(7.0f, 5.0f, 11.0f, 15.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(2.0f, 6.0f, 6.0f, 16.0f).texture("#3").cullface(direction);
                }
            }
        }).from(5.25f, 0.0f, 5.0f).to(7.25f, 2.0f, 11.0f).end()).texture("particle", magmaTexture)).texture("3", logTexture)).texture("4", logTopTexture);
        ModelBuilder logs_up = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name + "_logs_down")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#4");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(12.0f, 3.0f, 16.0f, 13.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(6.0f, 1.0f, 10.0f, 11.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(8.0f, 4.0f, 12.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                }
            }
        }).from(5.75f, 2.0f, 8.0f).to(10.75f, 4.0f, 10.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(5.0f, 3.0f, 9.0f, 13.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case EAST: 
                case WEST: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#4");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(1.0f, 4.0f, 5.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(9.0f, 0.0f, 13.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(9.0f, 6.0f, 13.0f, 16.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#3");
                }
            }
        }).from(5.0f, 2.0f, 5.5f).to(10.0f, 4.0f, 7.5f).end()).texture("particle", magmaTexture)).texture("3", logTexture)).texture("4", logTopTexture);
        MultiPartBlockStateBuilder builder = provider.getMultipartBuilder((Block)YTechBlocks.FIRE_PIT.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).addModel()).condition((Property)BlockStateProperties.LIT, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base_lit).addModel()).condition((Property)BlockStateProperties.LIT, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)logs_down).addModel()).condition((Property)BlockStateProperties.LEVEL, (Comparable[])new Integer[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)logs_up).addModel()).condition((Property)BlockStateProperties.LEVEL, (Comparable[])new Integer[]{9, 10, 11, 12, 13, 14, 15}).end();
        ((ItemModelBuilder)((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)provider.itemModels().getExistingFile(Utils.mcItemLoc("generated")))).texture("layer0", Utils.modItemLoc("fire_pit"));
    }

    public static void registerRecipe(RecipeOutput consumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechBlocks.FIRE_PIT.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), YTechItemTags.PEBBLES).pattern("SS").pattern("PP").unlockedBy("has_pebble", RecipeProvider.has(YTechItemTags.PEBBLES)).save(consumer, Utils.modLoc(YTechBlocks.FIRE_PIT));
    }

    private static boolean always(BlockState s, BlockGetter g, BlockPos p) {
        return true;
    }

    private static int getLightLevel(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? Math.min(15, (Integer)state.getValue((Property)BlockStateProperties.LEVEL) * 2 + 1) : 0;
    }

    private static void createFirePitTicker(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof FirePitBlockEntity) {
            FirePitBlockEntity block = (FirePitBlockEntity)blockEntity;
            block.tick(level, pos, state, block);
        }
    }
}

