/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.mojang.serialization.MapCodec;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;

public class GrassBedBlock
extends HorizontalDirectionalBlock {
    private static final MapCodec<GrassBedBlock> CODEC = GrassBedBlock.simpleCodec(prop -> new GrassBedBlock());
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public GrassBedBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.2f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean isBed(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable LivingEntity player) {
        return true;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        if (state.getValue((Property)BedBlock.PART) != BedPart.HEAD && !(state = level.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING)))).is((Block)this)) {
            return ItemInteractionResult.CONSUME;
        }
        if (!BedBlock.canSetSpawn((Level)level)) {
            level.removeBlock(pos, false);
            BlockPos relative = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (level.getBlockState(relative).is((Block)this)) {
                level.removeBlock(relative, false);
            }
            Vec3 center = pos.getCenter();
            level.explode(null, level.damageSources().badRespawnPointExplosion(center), null, center, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        player.startSleepInBed(pos).ifLeft(sleepingProblem -> {
            if (sleepingProblem.getMessage() != null) {
                player.displayClientMessage(sleepingProblem.getMessage(), true);
            }
        });
        return ItemInteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagers = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.getFirst()).stopSleeping();
        return true;
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor level, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (pFacing == GrassBedBlock.getNeighbourDirection((BedPart)state.getValue((Property)BedBlock.PART), (Direction)state.getValue((Property)FACING))) {
            return pFacingState.is((Block)this) && pFacingState.getValue((Property)BedBlock.PART) != state.getValue((Property)BedBlock.PART) ? (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)((Boolean)pFacingState.getValue((Property)BedBlock.OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, pFacing, pFacingState, level, pCurrentPos, pFacingPos);
    }

    private static Direction getNeighbourDirection(BedPart pPart, Direction pDirection) {
        return pPart == BedPart.FOOT ? pDirection : pDirection.getOpposite();
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart part;
        if (!level.isClientSide && player.isCreative() && (part = (BedPart)state.getValue((Property)BedBlock.PART)) == BedPart.FOOT && (blockState = level.getBlockState(blockPos = pos.relative(GrassBedBlock.getNeighbourDirection(part, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getHorizontalDirection();
        BlockPos clickedPos = pContext.getClickedPos();
        BlockPos relative = clickedPos.relative(direction);
        Level level = pContext.getLevel();
        return level.getBlockState(relative).canBeReplaced(pContext) && level.getWorldBorder().isWithinBounds(relative) ? (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT)).setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)) : null;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext pContext) {
        return BASE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, BedBlock.PART, BedBlock.OCCUPIED});
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.setPlacedBy(level, pos, state, pPlacer, pStack);
        if (!level.isClientSide) {
            BlockPos relative = pos.relative((Direction)state.getValue((Property)FACING));
            level.setBlock(relative, (BlockState)state.setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        String name = Utils.getPath(YTechBlocks.GRASS_BED);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(name)).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case EAST: {
                    faceBuilder.uvs(9.0f, 2.0f, 11.0f, 16.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(1.0f, 2.0f, 3.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(9.0f, 0.0f, 11.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 12.0f, 14.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 12.0f, 14.0f).texture("#1").cullface(direction);
                }
            }
        }).from(2.0f, 0.0f, 0.0f).to(14.0f, 2.0f, 14.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#0");
                }
            }
        }).from(13.0f, 0.0f, 0.0f).to(19.0f, 0.0f, 16.0f).rotation().angle(22.5f).axis(Direction.Axis.Z).origin(8.0f, 0.0f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#0");
                }
            }
        }).from(-3.0f, 0.0f, -1.0f).to(3.0f, 0.0f, 15.0f).rotation().angle(-22.5f).axis(Direction.Axis.Z).origin(8.0f, 0.0f, 8.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case UP: {
                    faceBuilder.uvs(0.0f, 3.0f, 16.0f, 9.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 3.0f, 16.0f, 9.0f).texture("#0");
                }
            }
        }).from(0.0f, 0.0f, 13.0f).to(16.0f, 0.0f, 19.0f).rotation().angle(-22.5f).axis(Direction.Axis.X).origin(8.0f, 0.0f, 8.0f).end().end()).renderType("minecraft:cutout")).texture("particle", Utils.modBlockLoc("thatch"))).texture("0", Utils.modBlockLoc("dried_grass"))).texture("1", Utils.modBlockLoc("thatch"));
        ((ItemModelBuilder)((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)provider.itemModels().getExistingFile(Utils.mcItemLoc("generated")))).texture("layer0", Utils.modItemLoc("grass_bed"));
        provider.getVariantBuilder((Block)YTechBlocks.GRASS_BED.get()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(90).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(180).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(270).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(180).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(270).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).build()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).with((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(90).build());
    }

    public static void registerLootTable(@NotNull BlockLootSubProvider provider) {
        provider.add((Block)YTechBlocks.GRASS_BED.get(), b -> provider.createSinglePropConditionTable(b, (Property)BedBlock.PART, (Comparable)BedPart.HEAD));
    }

    public static void registerRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechBlocks.GRASS_BED.get()).define(Character.valueOf('G'), YTechItemTags.THATCH_SLABS).define(Character.valueOf('S'), YTechItemTags.GRASS_FIBERS).pattern("SSS").pattern("GGG").pattern("GGG").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.THATCH_SLABS)).save(recipeConsumer, Utils.modLoc(YTechBlocks.GRASS_BED));
    }
}

