/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.mojang.serialization.MapCodec;
import com.yanny.ytech.configuration.block_entity.MachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlock
extends BaseEntityBlock {
    public MachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> entityType) {
        if (level.isClientSide) {
            if (this.hasClientTicker()) {
                return MachineBlock.createTickerHelper(entityType, entityType, MachineBlock::createMachineClientTicker);
            }
        } else if (this.hasServerTicker()) {
            return MachineBlock.createTickerHelper(entityType, entityType, MachineBlock::createMachineServerTicker);
        }
        return null;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof MachineBlockEntity) {
            MachineBlockEntity blockEntity2 = (MachineBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, blockEntity2.getItemStackHandler().getItems());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new RuntimeException("Not implemented yet!");
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult trace) {
        MenuProvider menuProvider;
        if (!level.isClientSide && (menuProvider = this.getMenuProvider(state, level, pos)) != null) {
            player.openMenu(menuProvider, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean hasClientTicker() {
        return false;
    }

    public boolean hasServerTicker() {
        return false;
    }

    public static void createMachineClientTicker(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity block = (MachineBlockEntity)blockEntity;
            block.tickClient(level, pos, state, block);
        }
    }

    public static void createMachineServerTicker(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity block = (MachineBlockEntity)blockEntity;
            block.tickServer(level, pos, state, block);
        }
    }
}

