/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), (VoxelShape)Shapes.box((double)0.375, (double)0.5, (double)0.375, (double)0.625, (double)1.0, (double)0.625));

    public MillstoneBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(3.5f));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MillstoneBlockEntity(pos, state);
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.MILLSTONE.get());
        if (optional.isPresent()) {
            return ((MillstoneBlockEntity)((Object)optional.get())).onUse(level, pos, player, hand);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof MillstoneBlockEntity) {
            MillstoneBlockEntity millstone = (MillstoneBlockEntity)blockEntity;
            NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            items.set(0, (Object)millstone.getInputItem());
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)items);
            millstone.onRemove();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.MILLSTONE))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 2.0f).texture("#side");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#slab");
                }
            }
        }).from(0.0f, 6.0f, 0.0f).to(16.0f, 8.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 6.0f, 16.0f, 8.0f).texture("#side").cullface(direction);
                }
            }
        }).from(0.0f, 4.0f, 0.0f).to(16.0f, 6.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 8.0f, 16.0f, 10.0f).texture("#side").cullface(direction);
                }
            }
        }).from(0.0f, 2.0f, 0.0f).to(16.0f, 4.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 14.0f, 16.0f, 16.0f).texture("#side").cullface(direction);
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#slab").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 2.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(12.0f, 0.0f, 16.0f, 8.0f).texture("#top");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 8.0f).texture("#top");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 0.0f, 8.0f, 8.0f).texture("#top");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(8.0f, 0.0f, 12.0f, 8.0f).texture("#top");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#middle");
                }
            }
        }).from(6.0f, 8.0f, 6.0f).to(10.0f, 16.0f, 10.0f).end()).texture("particle", Utils.mcBlockLoc("smooth_stone_slab_side"))).texture("side", Utils.mcBlockLoc("smooth_stone_slab_side"))).texture("slab", Utils.mcBlockLoc("smooth_stone"))).texture("middle", Utils.mcBlockLoc("oak_log_top"))).texture("top", Utils.mcBlockLoc("oak_log"));
        provider.getVariantBuilder((Block)YTechBlocks.MILLSTONE.get()).forAllStates(arg_0 -> MillstoneBlock.lambda$registerModel$5((ModelFile)model, arg_0));
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.MILLSTONE))).parent((ModelFile)model);
    }

    public static void registerRecipe(@NotNull RecipeOutput recipeConsumer) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.HAMMERS.tag, (ItemLike)YTechBlocks.MILLSTONE.get()).define(Character.valueOf('W'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE).bottomPattern("SSS").bottomPattern("SWS").bottomPattern("SSS").middlePattern("SSS").middlePattern("SWS").middlePattern("SSS").topPattern("   ").topPattern(" W ").topPattern("   ").unlockedBy("has_logs", RecipeProvider.has((TagKey)ItemTags.LOGS)).save(recipeConsumer, Utils.modLoc(YTechBlocks.MILLSTONE));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerModel$5(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }
}

