/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.WoodenBoxBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenBoxBlock
extends Block
implements EntityBlock {
    public static final VoxelShape BOX = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)0.25, (double)0.25);
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);

    public WoodenBoxBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new WoodenBoxBlockEntity(blockPos, blockState);
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.WOODEN_BOX.get());
        if (optional.isPresent()) {
            return ((WoodenBoxBlockEntity)((Object)optional.get())).onUse(level, pos, player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof WoodenBoxBlockEntity) {
            WoodenBoxBlockEntity woodenBoxBlockEntity = (WoodenBoxBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, woodenBoxBlockEntity.getItems());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HORIZONTAL_FACING});
    }

    public static int getIndex(int @Nullable [] position) {
        if (WoodenBoxBlock.validPosition(position)) {
            return position[1] * 3 + position[0];
        }
        return -1;
    }

    public static int @Nullable [] getPosition(BlockHitResult hit) {
        BlockPos pos = hit.getBlockPos();
        Vec3 position = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (position.x < 0.125 || position.x > 0.875 || position.z < 0.125 || position.z > 0.875) {
            return null;
        }
        position.subtract(0.125, 0.0, 0.125);
        position.multiply(1.3333333333333333, 1.0, 1.3333333333333333);
        int x = (int)Math.floor(position.x * 3.0);
        int z = (int)Math.floor(position.z * 3.0);
        if (x >= 0 && x < 3 && z >= 0 && z < 3) {
            return new int[]{x, z};
        }
        return null;
    }

    public static int @Nullable [] getPosition(int index) {
        if (index >= 0 && index < 9) {
            int z = index / 3;
            int x = index %= 3;
            return new int[]{x, z};
        }
        return null;
    }

    public static boolean validPosition(int @Nullable [] position) {
        return position != null && position[0] >= 0 && position[0] < 3 && position[1] >= 0 && position[1] < 3;
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.WOODEN_BOX))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case WEST: 
                case EAST: 
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 10.0f, 16.0f, 16.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 6.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).texture("#1");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(14.0f, 4.0f, 16.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 4.0f, 2.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 1.0f, 16.0f, 3.0f).texture("#0");
                }
            }
        }).from(0.0f, 6.0f, 0.0f).to(16.0f, 12.0f, 2.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).texture("#1");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 4.0f, 16.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 4.0f, 2.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 4.0f, 16.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 13.0f, 16.0f, 15.0f).texture("#0");
                }
            }
        }).from(0.0f, 6.0f, 14.0f).to(16.0f, 12.0f, 16.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case EAST: {
                    faceBuilder.uvs(2.0f, 4.0f, 14.0f, 10.0f).texture("#1");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(2.0f, 4.0f, 14.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 1.0f, 12.0f, 3.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#0");
                }
            }
        }).from(0.0f, 6.0f, 2.0f).to(2.0f, 12.0f, 14.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case WEST: {
                    faceBuilder.uvs(2.0f, 4.0f, 14.0f, 10.0f).texture("#1");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 4.0f, 14.0f, 10.0f).texture("#1").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(1.0f, 12.0f, 13.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#0");
                }
            }
        }).from(14.0f, 6.0f, 2.0f).to(16.0f, 12.0f, 14.0f).end()).texture("particle", Utils.modBlockLoc("wooden_box"))).texture("0", Utils.mcBlockLoc("oak_planks"))).texture("1", Utils.modBlockLoc("wooden_box"));
        provider.getVariantBuilder((Block)YTechBlocks.WOODEN_BOX.get()).forAllStates(arg_0 -> WoodenBoxBlock.lambda$registerModel$5((ModelFile)model, arg_0));
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.WOODEN_BOX))).parent((ModelFile)model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerModel$5(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }
}

