/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.AqueductValveBlock;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.network.irrigation.NetworkType;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductValveBlockEntity
extends IrrigationBlockEntity {
    private static final String TAG_FLOW = "flow";
    private int flow = 0;

    public AqueductValveBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.AQUEDUCT_VALVE.get()), pos, blockState, ((AqueductValveBlock)blockState.getBlock()).getValidNeighbors(blockState, pos));
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.flow = tag.getInt(TAG_FLOW);
    }

    @Override
    protected void onLevelSet(@NotNull ServerLevel level) {
        this.flow = this.calculateFlow(level);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @Override
    public int getFlow() {
        return this.flow;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return NetworkType.PROVIDER;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt(TAG_FLOW, this.flow);
    }

    public void neighborChanged() {
        if (this.level != null && !this.level.isClientSide) {
            int oldValue = this.flow;
            this.flow = this.calculateFlow((ServerLevel)this.level);
            if (oldValue != this.flow) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
        }
    }

    public void randomTick(@NotNull ServerLevel level) {
        IrrigationServerNetwork network;
        if (this.flow > 0 && (network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(this)) != null && level.random.nextInt(YTechMod.CONFIGURATION.getValveChanceToDrainWater()) == 0 && network.getFluidHandler().getFluidAmount() + YTechMod.CONFIGURATION.getValveFillAmount() <= network.getFluidHandler().getCapacity()) {
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            for (BlockPos pos : this.getValidNeighbors()) {
                BlockState blockState = level.getBlockState(pos);
                FluidState fluidState = blockState.getFluidState();
                if (!fluidState.is((Fluid)Fluids.WATER) && !fluidState.is((Fluid)Fluids.FLOWING_WATER)) continue;
                checkedBlocks.add(pos);
                BlockPos waterPos = fluidState.isSource() ? pos : this.findWaterSource(0, level, pos, checkedBlocks);
                if (waterPos == null) continue;
                BlockState waterBlockState = level.getBlockState(waterPos);
                if (waterBlockState.is(Blocks.WATER)) {
                    level.setBlockAndUpdate(waterPos, Blocks.AIR.defaultBlockState());
                } else if (waterBlockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    level.setBlockAndUpdate(waterPos, (BlockState)waterBlockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                }
                this.neighborChanged();
                return;
            }
        }
    }

    private int calculateFlow(@NotNull ServerLevel level) {
        return this.getValidNeighbors().stream().anyMatch(pos -> {
            BlockState blockState = level.getBlockState(pos);
            if (blockState.getBlock() == Blocks.WATER) {
                FluidState fluidState = blockState.getFluidState();
                return !fluidState.hasProperty((Property)FlowingFluid.FALLING) || (Boolean)fluidState.getValue((Property)FlowingFluid.FALLING) == false;
            }
            return false;
        }) ? YTechMod.CONFIGURATION.getValveFillAmount() : 0;
    }

    @Nullable
    private BlockPos findWaterSource(int waterLevel, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Set<BlockPos> checkedBlocks) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos waterPos;
            BlockPos offsetPos = pos.offset(direction.getNormal());
            BlockState blockState = level.getBlockState(offsetPos);
            FluidState fluidState = blockState.getFluidState();
            if (!fluidState.is((Fluid)Fluids.WATER) && !fluidState.is((Fluid)Fluids.FLOWING_WATER) || checkedBlocks.contains(offsetPos)) continue;
            checkedBlocks.add(offsetPos);
            if (fluidState.isSource()) {
                return offsetPos;
            }
            if ((Integer)fluidState.getValue((Property)BlockStateProperties.LEVEL_FLOWING) <= waterLevel || (waterPos = this.findWaterSource((Integer)fluidState.getValue((Property)BlockStateProperties.LEVEL_FLOWING), level, offsetPos, checkedBlocks)) == null) continue;
            return waterPos;
        }
        return null;
    }
}

