/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.entity.GoAroundEntity;
import com.yanny.ytech.configuration.recipe.MillingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlockEntity
extends BlockEntity {
    private static final String TAG_INPUT = "input";
    private static final String TAG_RESULT = "result";
    private static final String TAG_BONUS_CHANCE = "bonusChance";
    private static final String TAG_IS_MILLING = "isMilling";
    private static final String TAG_IS_LEASHED = "isLeashed";
    private ItemStack input = ItemStack.EMPTY;
    private ItemStack result = ItemStack.EMPTY;
    private float bonusChance = 0.0f;
    private boolean isMilling = false;
    private boolean isLeashed = false;
    @Nullable
    private GoAroundEntity entity = null;
    private final RecipeManager.CachedCheck<RecipeInput, MillingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)YTechRecipeTypes.MILLING.get()));

    public MillstoneBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.MILLSTONE.get(), pos, blockState);
    }

    public ItemInteractionResult onUse(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            if (!this.isLeashed) {
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                List mobList = level.getEntitiesOfClass(Mob.class, new AABB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0));
                for (Mob mob : mobList) {
                    if (mob.getLeashHolder() != player || !mob.getPassengers().isEmpty()) continue;
                    mob.dropLeash(true, false);
                    GoAroundEntity mimic = new GoAroundEntity(mob, pos, level);
                    level.addFreshEntity((Entity)mimic);
                    mimic.startRiding((Entity)mob, true);
                    break;
                }
            }
            ItemStack holdingItemStack = player.getItemInHand(hand);
            if (this.result.isEmpty() && this.isLeashed && !holdingItemStack.isEmpty()) {
                Optional millingRecipe = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(holdingItemStack), level);
                millingRecipe.ifPresent(r -> {
                    EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                    this.input = holdingItemStack.copyWithCount(holdingItemStack.getCount() - 1);
                    this.result = ((MillingRecipe)r.value()).result();
                    this.bonusChance = ((MillingRecipe)r.value()).bonusChance();
                    this.isMilling = true;
                    player.setItemSlot(slot, ItemStack.EMPTY);
                    MillstoneBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
                });
            }
            if (player.isCrouching() && player.getItemInHand(hand).isEmpty() && this.isLeashed && this.entity != null) {
                this.entity.stopRiding();
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.input = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_INPUT));
        this.result = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RESULT));
        this.bonusChance = tag.getFloat(TAG_BONUS_CHANCE);
        this.isMilling = tag.getBoolean(TAG_IS_MILLING);
        this.isLeashed = tag.getBoolean(TAG_IS_LEASHED);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean isMilling() {
        return this.isMilling;
    }

    public void onFinished() {
        if (this.level != null && !this.result.isEmpty()) {
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)this.result.copy());
            if (this.level.random.nextFloat() < this.bonusChance) {
                Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)this.result.copyWithCount(1));
            }
            if (this.input.isEmpty()) {
                this.isMilling = false;
                this.result = ItemStack.EMPTY;
            } else {
                this.input.setCount(this.input.getCount() - 1);
            }
            this.level.playSound(null, this.getBlockPos(), SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, this.level.random.nextFloat() * 0.25f + 0.75f, this.level.random.nextFloat() + 0.5f);
            MillstoneBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
        }
    }

    public void removeLeash() {
        if (this.level != null) {
            this.isLeashed = false;
            this.entity = null;
            this.isMilling = false;
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            MillstoneBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
        }
    }

    public void setLeashed(@NotNull GoAroundEntity entity) {
        if (this.level != null) {
            this.entity = entity;
            this.isLeashed = true;
            if (!this.input.isEmpty() && !this.result.isEmpty()) {
                this.isMilling = true;
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            MillstoneBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
        }
    }

    public void onRemove() {
        if (this.entity != null) {
            this.entity.stopRiding();
        }
    }

    public boolean isLeashed() {
        return this.isLeashed;
    }

    public ItemStack getInputItem() {
        return this.input;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_INPUT, this.input.saveOptional(provider));
        tag.put(TAG_RESULT, this.result.saveOptional(provider));
        tag.putFloat(TAG_BONUS_CHANCE, this.bonusChance);
        tag.putBoolean(TAG_IS_MILLING, this.isMilling);
        tag.putBoolean(TAG_IS_LEASHED, this.isLeashed);
    }
}

