/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

class SimpleProgressHandler<P extends RecipeInput, R extends Recipe<P>> {
    private static final String TAG_ITEM = "Item";
    private static final String TAG_TIME = "Time";
    private static final String TAG_TOTAL_TIME = "TotalTime";
    private ItemStack item = ItemStack.EMPTY;
    private float progress = 0.0f;
    private int total = 0;
    private final RecipeManager.CachedCheck<P, R> quickCheck;

    public SimpleProgressHandler(RecipeType<R> recipeType) {
        this.quickCheck = RecipeManager.createCheck(recipeType);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean isEmpty() {
        return this.item.isEmpty();
    }

    public int getProgress() {
        return Math.round(this.progress / (float)this.total * 100.0f);
    }

    public void clear() {
        this.total = 0;
        this.progress = 0.0f;
        this.item = ItemStack.EMPTY;
    }

    public boolean setupCrafting(@NotNull Level level, ItemStack input, Function<R, Integer> recipeTimeGetter, Function<ItemStack, P> recipeInputGetter) {
        Optional recipeHolder = this.quickCheck.getRecipeFor((RecipeInput)recipeInputGetter.apply(input), level);
        if (recipeHolder.isPresent()) {
            this.total = recipeTimeGetter.apply(((RecipeHolder)recipeHolder.get()).value());
            this.item = input.split(1);
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public boolean tick(@NotNull Level level, Function<R, Boolean> canProcess, Function<R, Float> recipeStepGetter, BiConsumer<P, R> onFinish, Function<ItemStack, P> recipeInputGetter) {
        Recipe recipe;
        RecipeInput recipeInput;
        Optional recipeHolder;
        if (!this.item.isEmpty() && (recipeHolder = this.quickCheck.getRecipeFor(recipeInput = (RecipeInput)recipeInputGetter.apply(this.item), level)).isPresent() && canProcess.apply(recipe = ((RecipeHolder)recipeHolder.get()).value()).booleanValue()) {
            ItemStack result;
            this.progress += recipeStepGetter.apply(recipe).floatValue();
            if (this.progress >= (float)this.total && (result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                this.clear();
                onFinish.accept(recipeInput, recipe);
            }
            return true;
        }
        return false;
    }

    public void load(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.item = tag.contains(TAG_ITEM) ? ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound(TAG_ITEM)).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        if (tag.contains(TAG_TIME)) {
            this.progress = tag.getFloat(TAG_TIME);
        }
        if (tag.contains(TAG_TOTAL_TIME)) {
            this.total = tag.getInt(TAG_TOTAL_TIME);
        }
    }

    public void save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        if (!this.item.isEmpty()) {
            tag.put(TAG_ITEM, this.item.save(provider, (Tag)new CompoundTag()));
        }
        tag.putFloat(TAG_TIME, this.progress);
        tag.putInt(TAG_TOTAL_TIME, this.total);
    }
}

