/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.data_component.BasketContents;
import com.yanny.ytech.registration.YTechDataComponentTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class BasketItem
extends Item {
    public static final ResourceLocation FILLED_PREDICATE = Utils.modLoc("filled");
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public BasketItem() {
        super(new Item.Properties().stacksTo(1).component(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY));
    }

    public static float getFullnessDisplay(@NotNull ItemStack stack) {
        BasketContents bundleContents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return bundleContents.weight().floatValue();
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        int i;
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        BasketContents bundleContents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (bundleContents == null) {
            return false;
        }
        ItemStack slotItem = slot.getItem();
        BasketContents.Mutable mutableBundleContents = new BasketContents.Mutable(bundleContents);
        if (slotItem.isEmpty()) {
            this.playRemoveOneSound((Entity)player);
            ItemStack removed = mutableBundleContents.removeOne();
            if (removed != null) {
                ItemStack insert = slot.safeInsert(removed);
                mutableBundleContents.tryInsert(insert);
            }
        } else if (slotItem.getItem().canFitInsideContainerItems() && (i = mutableBundleContents.tryTransfer(slot, player)) > 0) {
            this.playInsertSound((Entity)player);
        }
        stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)mutableBundleContents.toImmutable());
        return true;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            BasketContents bundleContents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
            if (bundleContents == null) {
                return false;
            }
            BasketContents.Mutable mutableBundleContents = new BasketContents.Mutable(bundleContents);
            if (other.isEmpty()) {
                ItemStack itemstack = mutableBundleContents.removeOne();
                if (itemstack != null) {
                    this.playRemoveOneSound((Entity)player);
                    access.set(itemstack);
                }
            } else {
                int i = mutableBundleContents.tryInsert(other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                }
            }
            stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)mutableBundleContents.toImmutable());
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (BasketItem.dropContents(itemStack, player)) {
            this.playDropContentsSound((Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        BasketContents contents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return contents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        BasketContents contents = (BasketContents)stack.getOrDefault(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)contents.weight(), (int)12), 13);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return BAR_COLOR;
    }

    private static boolean dropContents(@NotNull ItemStack stack, @NotNull Player player) {
        BasketContents bundleContents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (bundleContents != null && !bundleContents.isEmpty()) {
            stack.set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
            if (player instanceof ServerPlayer) {
                bundleContents.itemsCopy().forEach(itemStack -> player.drop(itemStack, true));
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS)).map(BasketContents.BasketTooltip::new) : Optional.empty();
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        BasketContents bundleContents = (BasketContents)stack.get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (bundleContents != null) {
            int i = Mth.mulAndTruncate((Fraction)bundleContents.weight(), (int)16);
            components.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, 16}).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onDestroyed(@NotNull ItemEntity itemEntity) {
        BasketContents bundleContents = (BasketContents)itemEntity.getItem().get(YTechDataComponentTypes.BASKET_CONTENTS);
        if (bundleContents != null) {
            itemEntity.getItem().set(YTechDataComponentTypes.BASKET_CONTENTS, (Object)BasketContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, bundleContents.itemsCopy());
        }
    }

    private void playRemoveOneSound(@NotNull Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(@NotNull Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(@NotNull Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }
}

