/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.configuration.entity.PebbleEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PebbleItem
extends Item {
    public PebbleItem() {
        super(new Item.Properties());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.pebble").withStyle(ChatFormatting.DARK_GRAY));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            PebbleEntity pebble = new PebbleEntity(level, (LivingEntity)player);
            pebble.setItem(itemInHand);
            pebble.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 2.0f);
            level.addFreshEntity((Entity)pebble);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemInHand.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)level.isClientSide());
    }
}

