/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.google.common.collect.ImmutableList;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.entity.AurochsEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AurochsModel
extends AgeableListModel<AurochsEntity> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("aurochs"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart fl_foot;
    @NotNull
    private final ModelPart bl_foot;
    @NotNull
    private final ModelPart fr_foot;
    @NotNull
    private final ModelPart br_foot;
    private float headXRot;

    public AurochsModel(@NotNull ModelPart root) {
        super(false, 10.0f, 5.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.fl_foot = root.getChild("fl_foot");
        this.bl_foot = root.getChild("bl_foot");
        this.fr_foot = root.getChild("fr_foot");
        this.br_foot = root.getChild("br_foot");
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.fl_foot, (Object)this.bl_foot, (Object)this.fr_foot, (Object)this.br_foot);
    }

    public void setupAnim(@NotNull AurochsEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = this.headXRot;
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.fl_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.bl_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.fr_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.br_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.head.getChild((String)"horns").visible = !entity.isBaby();
    }

    public void prepareMobModel(@NotNull AurochsEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.head.y = 3.0f + pEntity.getHeadEatPositionScale(pPartialTick) * (pEntity.isBaby() ? 3.0f : 9.0f);
        this.headXRot = pEntity.getHeadEatAngleScale(pPartialTick);
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -5.75f, -6.5f, 12.0f, 13.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(-5.0f, -6.75f, -8.5f, 10.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.75f, (float)-1.5f));
        partdefinition.addOrReplaceChild("fl_foot", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)12.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("bl_foot", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)12.0f, (float)9.0f));
        partdefinition.addOrReplaceChild("fr_foot", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)12.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("br_foot", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)12.0f, (float)9.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(34, 49).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-10.0f));
        PartDefinition horns = head.addOrReplaceChild("horns", CubeListBuilder.create().texOffs(0, 16).addBox(4.0f, -4.0f, -3.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(44, 16).addBox(-8.0f, -4.0f, -3.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        horns.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(10, 16).addBox(6.9853f, -3.5f, 3.4497f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 0).addBox(-4.7426f, -3.5f, -9.2782f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

