/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.google.common.collect.ImmutableList;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.entity.FowlEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FowlModel
extends AgeableListModel<FowlEntity> {
    @NotNull
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Utils.modLoc("fowl"), "main");
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart l_wing;
    @NotNull
    private final ModelPart r_wing;
    @NotNull
    private final ModelPart l_foot;
    @NotNull
    private final ModelPart r_foot;

    public FowlModel(@NotNull ModelPart root) {
        super(false, 5.0f, 2.0f);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.l_wing = root.getChild("l_wing");
        this.r_wing = root.getChild("r_wing");
        this.l_foot = root.getChild("l_foot");
        this.r_foot = root.getChild("r_foot");
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.l_wing, (Object)this.r_wing, (Object)this.l_foot, (Object)this.r_foot);
    }

    public void setupAnim(@NotNull FowlEntity entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.r_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
        this.l_foot.xRot = Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
        this.r_wing.zRot = pAgeInTicks;
        this.l_wing.zRot = -pAgeInTicks;
    }

    @NotNull
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -11.0f, -4.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(14, 15).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -3.0f, -4.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("l_wing", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("r_wing", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("l_foot", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-3, 5).addBox(-1.0f, 5.0f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)19.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("r_foot", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-3, 5).addBox(-2.0f, 5.0f, -2.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }
}

