/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemainingShapelessRecipe
extends ShapelessRecipe {
    public RemainingShapelessRecipe(String p_249640_, CraftingBookCategory p_249390_, ItemStack p_252071_, NonNullList<Ingredient> p_250689_) {
        super(p_249640_, p_249390_, p_252071_, p_250689_);
    }

    public RemainingShapelessRecipe(ShapelessRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.getResultItem(null), recipe.getIngredients());
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput container) {
        NonNullList list = NonNullList.withSize((int)container.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = container.getItem(i);
            if (item.hasCraftingRemainingItem()) {
                list.set(i, (Object)item.getCraftingRemainingItem());
                continue;
            }
            if (!item.isDamageableItem()) continue;
            ItemStack result = item.copy();
            list.set(i, (Object)result);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) continue;
            result.hurtAndBreak(1, server.overworld(), null, it -> {});
        }
        return list;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.REMAINING_SHAPELESS.get();
    }

    public static class Builder
    extends ShapelessRecipeBuilder {
        public Builder(RecipeCategory pCategory, ItemLike pResult, int pCount) {
            super(pCategory, pResult, pCount);
        }

        public static Builder shapeless(@NotNull RecipeCategory pCategory, ItemLike pResult) {
            return new Builder(pCategory, pResult, 1);
        }

        public static Builder shapeless(@NotNull RecipeCategory pCategory, ItemLike pResult, int pCount) {
            return new Builder(pCategory, pResult, pCount);
        }

        public void save(final @NotNull RecipeOutput consumer, @NotNull ResourceLocation id) {
            super.save(new RecipeOutput(){

                @NotNull
                public Advancement.Builder advancement() {
                    return consumer.advancement();
                }

                public void accept(@NotNull ResourceLocation id, @NotNull Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... iConditions) {
                    consumer.accept(id, (Recipe)new RemainingShapelessRecipe((ShapelessRecipe)recipe), advancementHolder);
                }
            }, id);
        }
    }

    public static class Serializer
    implements RecipeSerializer<RemainingShapelessRecipe> {
        private static final MapCodec<RemainingShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] aingredient = (Ingredient[])ingredients.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)instance, RemainingShapelessRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RemainingShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<RemainingShapelessRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RemainingShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static RemainingShapelessRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf friendlyByteBuf) {
            return new RemainingShapelessRecipe(ShapelessRecipe.Serializer.fromNetwork((RegistryFriendlyByteBuf)friendlyByteBuf));
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buf, @NotNull RemainingShapelessRecipe recipe) {
            ShapelessRecipe.Serializer.toNetwork((RegistryFriendlyByteBuf)buf, (ShapelessRecipe)recipe);
        }
    }
}

