/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block_entity.AqueductBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationClientNetwork;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AqueductRenderer
implements BlockEntityRenderer<AqueductBlockEntity> {
    private final TextureAtlasSprite sprite;
    private final float r;
    private final float g;
    private final float b;
    private final float a;
    private final float minU;
    private final float minV;
    private final float maxU;
    private final float maxV;

    public AqueductRenderer(BlockEntityRendererProvider.Context context) {
        FlowingFluid fluid = Fluids.WATER;
        FluidStack fluidStack = new FluidStack((Fluid)fluid, 1000);
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        int color = extensions.getTintColor(fluidStack);
        this.sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(extensions.getStillTexture(fluidStack));
        this.a = (float)(color >> 24 & 0xFF) / 255.0f;
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
        this.minU = this.sprite.getU0();
        this.minV = this.sprite.getV0();
        this.maxU = this.sprite.getU1();
        this.maxV = this.sprite.getV1();
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull AqueductBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos());
    }

    public void render(@NotNull AqueductBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        IrrigationClientNetwork network = YTechMod.IRRIGATION_PROPAGATOR.client().getNetwork(blockEntity);
        if (network != null && network.getCapacity() > 0 && network.getAmount() > 0) {
            float height = 0.125f + (float)network.getAmount() / (float)network.getCapacity() * 0.75f;
            this.renderFluidBlock(blockEntity.getLevel(), blockEntity.getBlockPos(), poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)InventoryMenu.BLOCK_ATLAS)), height, packedOverlay);
        }
    }

    private static BakedQuad createQuad(List<Vec3> vectors, float[] cols, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
        QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)face.getNormal());
        AqueductRenderer.putVertex(quadBaker, normal, vectors.get((int)0).x, vectors.get((int)0).y, vectors.get((int)0).z, u1, v1, sprite, cols, face);
        AqueductRenderer.putVertex(quadBaker, normal, vectors.get((int)1).x, vectors.get((int)1).y, vectors.get((int)1).z, u1, v2, sprite, cols, face);
        AqueductRenderer.putVertex(quadBaker, normal, vectors.get((int)2).x, vectors.get((int)2).y, vectors.get((int)2).z, u2, v2, sprite, cols, face);
        AqueductRenderer.putVertex(quadBaker, normal, vectors.get((int)3).x, vectors.get((int)3).y, vectors.get((int)3).z, u2, v1, sprite, cols, face);
        return quadBaker.bakeQuad();
    }

    private static void putVertex(QuadBakingVertexConsumer quadBaker, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float[] cols, Direction face) {
        quadBaker.addVertex((float)x, (float)y, (float)z);
        quadBaker.setNormal((float)normal.x, (float)normal.y, (float)normal.z);
        quadBaker.setColor(cols[0], cols[1], cols[2], cols[3]);
        quadBaker.setUv(u, v);
        quadBaker.setSprite(sprite);
        quadBaker.setDirection(face);
    }

    public void renderFluidBlock(Level level, BlockPos pos, PoseStack matrixStackIn, VertexConsumer builder, float height, int packedOverlay) {
        int brightness = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
        float x = 0.0f;
        float z = 0.0f;
        float x2 = 1.0f;
        float z2 = 1.0f;
        float[] cols = new float[]{this.r, this.g, this.b, this.a};
        matrixStackIn.pushPose();
        BakedQuad quad = AqueductRenderer.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)height, (double)z), (Object)new Vec3((double)x, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z)), cols, this.sprite, Direction.UP, this.minU, this.maxU, this.minV, this.maxV);
        builder.putBulkData(matrixStackIn.last(), quad, this.r, this.g, this.b, this.a, brightness, packedOverlay, false);
        matrixStackIn.popPose();
    }
}

