/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeCraftingWorkspaceLevel
extends Level {
    private Level level;
    private BlockPos originalPos;
    @Nullable
    private NonNullList<ItemStack> items;
    @Nullable
    private NonNullList<BlockState> blockStates;
    private LevelTickAccess<Block> blockTickAccess;
    private LevelTickAccess<Fluid> fluidTickAccess;
    private LevelEntityGetter<Entity> levelEntityGetter;

    public FakeCraftingWorkspaceLevel() {
        super(null, null, null, null, null, false, false, 0L, 0);
    }

    public void init() {
        this.blockTickAccess = new LevelTickAccess<Block>(this){

            public void schedule(@NotNull ScheduledTick pTick) {
            }

            public boolean hasScheduledTick(@NotNull BlockPos pPos, @NotNull Block pType) {
                return false;
            }

            public int count() {
                return 0;
            }

            public boolean willTickThisTick(@NotNull BlockPos pPos, @NotNull Block pType) {
                return false;
            }
        };
        this.fluidTickAccess = new LevelTickAccess<Fluid>(this){

            public boolean willTickThisTick(@NotNull BlockPos pPos, @NotNull Fluid pType) {
                return false;
            }

            public void schedule(@NotNull ScheduledTick<Fluid> pTick) {
            }

            public boolean hasScheduledTick(@NotNull BlockPos pPos, @NotNull Fluid pType) {
                return false;
            }

            public int count() {
                return 0;
            }
        };
        this.levelEntityGetter = new LevelEntityGetter<Entity>(this){

            @Nullable
            public Entity get(int pId) {
                return null;
            }

            @Nullable
            public Entity get(@NotNull UUID pUuid) {
                return null;
            }

            @NotNull
            public Iterable<Entity> getAll() {
                return List.of();
            }

            public <U extends Entity> void get(@NotNull EntityTypeTest<Entity, U> pTest, @NotNull AbortableIterationConsumer<U> pConsumer) {
            }

            public void get(@NotNull AABB pBoundingBox, @NotNull Consumer<Entity> pConsumer) {
            }

            public <U extends Entity> void get(@NotNull EntityTypeTest<Entity, U> pTest, @NotNull AABB pBounds, @NotNull AbortableIterationConsumer<U> pConsumer) {
            }
        };
    }

    public float getShade(@NotNull Direction pDirection, boolean pShade) {
        return this.level.getShade(pDirection, pShade);
    }

    public void sendBlockUpdated(@NotNull BlockPos pPos, @NotNull BlockState pOldState, @NotNull BlockState pNewState, int pFlags) {
    }

    @NotNull
    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    public int getBrightness(@NotNull LightLayer pLightType, @NotNull BlockPos pBlockPos) {
        return this.level.getBrightness(pLightType, this.originalPos);
    }

    public int getBlockTint(@NotNull BlockPos pPos, @NotNull ColorResolver pColorResolver) {
        return this.level.getBlockTint(this.originalPos, pColorResolver);
    }

    @NotNull
    public Holder<Biome> getUncachedNoiseBiome(int pX, int pY, int pZ) {
        return this.level.getUncachedNoiseBiome(pX, pY, pZ);
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pPos) {
        return null;
    }

    @Nullable
    public Entity getEntity(int pId) {
        return this.level.getEntity(pId);
    }

    @NotNull
    public TickRateManager tickRateManager() {
        return null;
    }

    @Nullable
    public MapItemSavedData getMapData(@NotNull MapId p_324234_) {
        return null;
    }

    public void setMapData(@NotNull MapId p_324009_, @NotNull MapItemSavedData p_151534_) {
    }

    @NotNull
    public MapId getFreeMapId() {
        return this.level.getFreeMapId();
    }

    public void destroyBlockProgress(int pBreakerId, @NotNull BlockPos pPos, int pProgress) {
    }

    @NotNull
    public Scoreboard getScoreboard() {
        return this.level.getScoreboard();
    }

    @NotNull
    public RecipeManager getRecipeManager() {
        return this.level.getRecipeManager();
    }

    @NotNull
    protected LevelEntityGetter<Entity> getEntities() {
        return this.levelEntityGetter;
    }

    @NotNull
    public PotionBrewing potionBrewing() {
        return null;
    }

    public void setDayTimeFraction(float v) {
    }

    public float getDayTimeFraction() {
        return 0.0f;
    }

    public float getDayTimePerTick() {
        return 0.0f;
    }

    public void setDayTimePerTick(float v) {
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pPos) {
        if (pPos.getX() > 0 && pPos.getX() <= 3 && pPos.getY() > 0 && pPos.getY() <= 3 && pPos.getZ() > 0 && pPos.getZ() <= 3 && this.items != null && this.blockStates != null) {
            int[] position = CraftingWorkspaceBlock.getPosition(pPos.getX() - 1 + (pPos.getZ() - 1) * 3 + (pPos.getY() - 1) * 9);
            int index = CraftingWorkspaceBlock.getIndex(position);
            if (position == null) {
                return Blocks.AIR.defaultBlockState();
            }
            return (BlockState)this.blockStates.get(index);
        }
        if (pPos.getY() == 0) {
            return Blocks.STONE.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pPos) {
        return Blocks.AIR.defaultBlockState().getFluidState();
    }

    public void playSeededSound(@Nullable Player pPlayer, double pX, double pY, double pZ, @NotNull Holder<SoundEvent> pSound, @NotNull SoundSource pSource, float pVolume, float pPitch, long pSeed) {
    }

    public void playSeededSound(@Nullable Player pPlayer, @NotNull Entity pEntity, @NotNull Holder<SoundEvent> pSound, @NotNull SoundSource pCategory, float pVolume, float pPitch, long pSeed) {
    }

    @NotNull
    public String gatherChunkSourceStats() {
        return "";
    }

    public int getHeight() {
        return this.level.getHeight();
    }

    @NotNull
    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    public int getMinBuildHeight() {
        return this.level.getMinBuildHeight();
    }

    public int getRawBrightness(@NotNull BlockPos pBlockPos, int pAmount) {
        return this.getLightEngine().getRawBrightness(this.originalPos, pAmount);
    }

    public boolean canSeeSky(@NotNull BlockPos pBlockPos) {
        return this.getBrightness(LightLayer.SKY, this.originalPos) >= this.getMaxLightLevel();
    }

    public void setData(@NotNull BlockPos pos, @NotNull Level level, @NotNull NonNullList<ItemStack> items, NonNullList<BlockState> blockStates) {
        this.originalPos = pos;
        this.level = level;
        this.items = items;
        this.blockStates = blockStates;
    }

    public void clearData() {
        this.originalPos = null;
        this.level = null;
        this.items = null;
        this.blockStates = null;
    }

    @NotNull
    public LevelTickAccess<Block> getBlockTicks() {
        return this.blockTickAccess;
    }

    @NotNull
    public LevelTickAccess<Fluid> getFluidTicks() {
        return this.fluidTickAccess;
    }

    @NotNull
    public ChunkSource getChunkSource() {
        return null;
    }

    public void levelEvent(@Nullable Player pPlayer, int pType, @NotNull BlockPos pPos, int pData) {
    }

    public void gameEvent(@Nullable Entity p_151549_, @NotNull Holder<GameEvent> p_316314_, @NotNull Vec3 p_316613_) {
    }

    public void gameEvent(@NotNull Holder<GameEvent> p_316267_, @NotNull Vec3 p_220405_, @NotNull GameEvent.Context p_220406_) {
    }

    public void gameEvent(@Nullable Entity p_316772_, @NotNull Holder<GameEvent> p_316248_, @NotNull BlockPos p_316282_) {
    }

    public void gameEvent(@NotNull Holder<GameEvent> p_316320_, @NotNull BlockPos p_220409_, @NotNull GameEvent.Context p_220410_) {
    }

    public void gameEvent(@NotNull ResourceKey<GameEvent> p_316780_, @NotNull BlockPos p_316509_, @NotNull GameEvent.Context p_316524_) {
    }

    @NotNull
    public List<? extends Player> players() {
        return List.of();
    }

    public void scheduleTick(@NotNull BlockPos pPos, @NotNull Block pBlock, int pDelay) {
    }

    public void scheduleTick(@NotNull BlockPos pPos, @NotNull Fluid pFluid, int pDelay) {
    }

    public void scheduleTick(@NotNull BlockPos pPos, @NotNull Block pBlock, int pDelay, @NotNull TickPriority pPriority) {
    }

    public void scheduleTick(@NotNull BlockPos pPos, @NotNull Fluid pFluid, int pDelay, @NotNull TickPriority pPriority) {
    }
}

