/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.StrainerBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class StrainerRenderer
implements BlockEntityRenderer<StrainerBlockEntity> {
    private final BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)Utils.modLoc("block/strainer_net")));
    private final ModelBlockRenderer renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();

    public StrainerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull StrainerBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.getBlockState();
        Level level = blockEntity.getLevel();
        if (level != null && blockEntity.hasMesh()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 1.0f, 0.0f);
            int i = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos().above());
            this.renderer.renderModel(poseStack.last(), buffer.getBuffer(RenderType.cutout()), blockState, this.model, 1.0f, 1.0f, 1.0f, i, packedOverlay, ModelData.EMPTY, RenderType.cutout());
            poseStack.popPose();
        }
    }
}

